/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openl.rules.enumeration.CaProvincesEnum;
import org.openl.rules.enumeration.CaRegionsEnum;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.OriginsEnum;
import org.openl.rules.enumeration.RecalculateEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.enumeration.ValidateDTEnum;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DynamicObject;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.EnumUtils;
import org.openl.util.StringUtils;

public class TableProperties
extends DynamicObject
implements ITableProperties {
    private String currentTableType;
    private ILogicalTable propertySection;
    private ILogicalTable modulePropertiesTable;
    private ILogicalTable categoryPropertiesTable;
    private Map<String, Object> categoryProperties = Collections.emptyMap();
    private Map<String, Object> externalModuleProperties = Collections.emptyMap();
    private Map<String, Object> moduleProperties = Collections.emptyMap();
    private Map<String, Object> defaultProperties = Collections.emptyMap();
    private Map<String, Object> allProperties = null;

    private Map<String, Object> mergeLevelProperties(Map<String, Object> downLevelProperties, Map<String, Object> upLevelProperties) {
        Map<String, Object> resultProperties = downLevelProperties;
        for (Map.Entry<String, Object> upLevelProperty : upLevelProperties.entrySet()) {
            String upLevelPropertyName = upLevelProperty.getKey();
            Object upLevelPropertyValue = upLevelProperty.getValue();
            if (!PropertiesChecker.isPropertySuitableForTableType(upLevelPropertyName, this.currentTableType) || downLevelProperties.containsKey(upLevelPropertyName)) continue;
            resultProperties.put(upLevelPropertyName, upLevelPropertyValue);
        }
        return resultProperties;
    }

    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.getClass());
    }

    public void setType(IOpenClass type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    @Override
    public void setName(String name) {
        this.setFieldValue("name", name);
        this.allProperties = null;
    }

    @Override
    public String getCategory() {
        return (String)this.getPropertyValue("category");
    }

    @Override
    public void setCategory(String category) {
        this.setFieldValue("category", category);
        this.allProperties = null;
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("createdBy");
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.setFieldValue("createdBy", createdBy);
        this.allProperties = null;
    }

    @Override
    public Date getCreatedOn() {
        return (Date)this.getPropertyValue("createdOn");
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.setFieldValue("createdOn", createdOn);
        this.allProperties = null;
    }

    @Override
    public String getModifiedBy() {
        return (String)this.getPropertyValue("modifiedBy");
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.setFieldValue("modifiedBy", modifiedBy);
        this.allProperties = null;
    }

    @Override
    public Date getModifiedOn() {
        return (Date)this.getPropertyValue("modifiedOn");
    }

    @Override
    public void setModifiedOn(Date modifiedOn) {
        this.setFieldValue("modifiedOn", modifiedOn);
        this.allProperties = null;
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("description");
    }

    @Override
    public void setDescription(String description) {
        this.setFieldValue("description", description);
        this.allProperties = null;
    }

    @Override
    public String[] getTags() {
        return (String[])this.getPropertyValue("tags");
    }

    @Override
    public void setTags(String[] tags) {
        this.setFieldValue("tags", tags);
        this.allProperties = null;
    }

    @Override
    public Date getEffectiveDate() {
        return (Date)this.getPropertyValue("effectiveDate");
    }

    @Override
    public void setEffectiveDate(Date effectiveDate) {
        this.setFieldValue("effectiveDate", effectiveDate);
        this.allProperties = null;
    }

    @Override
    public Date getExpirationDate() {
        return (Date)this.getPropertyValue("expirationDate");
    }

    @Override
    public void setExpirationDate(Date expirationDate) {
        this.setFieldValue("expirationDate", expirationDate);
        this.allProperties = null;
    }

    @Override
    public Date getStartRequestDate() {
        return (Date)this.getPropertyValue("startRequestDate");
    }

    @Override
    public void setStartRequestDate(Date startRequestDate) {
        this.setFieldValue("startRequestDate", startRequestDate);
        this.allProperties = null;
    }

    @Override
    public Date getEndRequestDate() {
        return (Date)this.getPropertyValue("endRequestDate");
    }

    @Override
    public void setEndRequestDate(Date endRequestDate) {
        this.setFieldValue("endRequestDate", endRequestDate);
        this.allProperties = null;
    }

    @Override
    public CaRegionsEnum[] getCaRegions() {
        return (CaRegionsEnum[])this.getPropertyValue("caRegions");
    }

    @Override
    public void setCaRegions(CaRegionsEnum[] caRegions) {
        this.setFieldValue("caRegions", caRegions);
        this.allProperties = null;
    }

    @Override
    public CaProvincesEnum[] getCaProvinces() {
        return (CaProvincesEnum[])this.getPropertyValue("caProvinces");
    }

    @Override
    public void setCaProvinces(CaProvincesEnum[] caProvinces) {
        this.setFieldValue("caProvinces", caProvinces);
        this.allProperties = null;
    }

    @Override
    public CountriesEnum[] getCountry() {
        return (CountriesEnum[])this.getPropertyValue("country");
    }

    @Override
    public void setCountry(CountriesEnum[] country) {
        this.setFieldValue("country", country);
        this.allProperties = null;
    }

    @Override
    public RegionsEnum[] getRegion() {
        return (RegionsEnum[])this.getPropertyValue("region");
    }

    @Override
    public void setRegion(RegionsEnum[] region) {
        this.setFieldValue("region", region);
        this.allProperties = null;
    }

    @Override
    public CurrenciesEnum[] getCurrency() {
        return (CurrenciesEnum[])this.getPropertyValue("currency");
    }

    @Override
    public void setCurrency(CurrenciesEnum[] currency) {
        this.setFieldValue("currency", currency);
        this.allProperties = null;
    }

    @Override
    public LanguagesEnum[] getLang() {
        return (LanguagesEnum[])this.getPropertyValue("lang");
    }

    @Override
    public void setLang(LanguagesEnum[] lang) {
        this.setFieldValue("lang", lang);
        this.allProperties = null;
    }

    @Override
    public String getLob() {
        return (String)this.getPropertyValue("lob");
    }

    @Override
    public void setLob(String lob) {
        this.setFieldValue("lob", lob);
        this.allProperties = null;
    }

    @Override
    public OriginsEnum getOrigin() {
        return (OriginsEnum)((Object)this.getPropertyValue("origin"));
    }

    @Override
    public void setOrigin(OriginsEnum origin) {
        this.setFieldValue("origin", (Object)origin);
        this.allProperties = null;
    }

    @Override
    public UsRegionsEnum[] getUsregion() {
        return (UsRegionsEnum[])this.getPropertyValue("usregion");
    }

    @Override
    public void setUsregion(UsRegionsEnum[] usregion) {
        this.setFieldValue("usregion", usregion);
        this.allProperties = null;
    }

    @Override
    public UsStatesEnum[] getState() {
        return (UsStatesEnum[])this.getPropertyValue("state");
    }

    @Override
    public void setState(UsStatesEnum[] state) {
        this.setFieldValue("state", state);
        this.allProperties = null;
    }

    @Override
    public String getVersion() {
        return (String)this.getPropertyValue("version");
    }

    @Override
    public void setVersion(String version) {
        this.setFieldValue("version", version);
        this.allProperties = null;
    }

    @Override
    public Boolean getActive() {
        return (Boolean)this.getPropertyValue("active");
    }

    @Override
    public void setActive(Boolean active) {
        this.setFieldValue("active", active);
        this.allProperties = null;
    }

    @Override
    public String getId() {
        return (String)this.getPropertyValue("id");
    }

    @Override
    public void setId(String id) {
        this.setFieldValue("id", id);
        this.allProperties = null;
    }

    @Override
    public String getBuildPhase() {
        return (String)this.getPropertyValue("buildPhase");
    }

    @Override
    public void setBuildPhase(String buildPhase) {
        this.setFieldValue("buildPhase", buildPhase);
        this.allProperties = null;
    }

    @Override
    public ValidateDTEnum getValidateDT() {
        return (ValidateDTEnum)((Object)this.getPropertyValue("validateDT"));
    }

    @Override
    public void setValidateDT(ValidateDTEnum validateDT) {
        this.setFieldValue("validateDT", (Object)validateDT);
        this.allProperties = null;
    }

    @Override
    public Boolean getFailOnMiss() {
        return (Boolean)this.getPropertyValue("failOnMiss");
    }

    @Override
    public void setFailOnMiss(Boolean failOnMiss) {
        this.setFieldValue("failOnMiss", failOnMiss);
        this.allProperties = null;
    }

    @Override
    public String getScope() {
        return (String)this.getPropertyValue("scope");
    }

    @Override
    public void setScope(String scope) {
        this.setFieldValue("scope", scope);
        this.allProperties = null;
    }

    @Override
    public String getDatatypePackage() {
        return (String)this.getPropertyValue("datatypePackage");
    }

    @Override
    public void setDatatypePackage(String datatypePackage) {
        this.setFieldValue("datatypePackage", datatypePackage);
        this.allProperties = null;
    }

    @Override
    public String[] getTransaction() {
        return (String[])this.getPropertyValue("transaction");
    }

    @Override
    public void setTransaction(String[] transaction) {
        this.setFieldValue("transaction", transaction);
        this.allProperties = null;
    }

    @Override
    public String[] getCustom1() {
        return (String[])this.getPropertyValue("custom1");
    }

    @Override
    public void setCustom1(String[] custom1) {
        this.setFieldValue("custom1", custom1);
        this.allProperties = null;
    }

    @Override
    public String[] getCustom2() {
        return (String[])this.getPropertyValue("custom2");
    }

    @Override
    public void setCustom2(String[] custom2) {
        this.setFieldValue("custom2", custom2);
        this.allProperties = null;
    }

    @Override
    public Boolean getCacheable() {
        return (Boolean)this.getPropertyValue("cacheable");
    }

    @Override
    public void setCacheable(Boolean cacheable) {
        this.setFieldValue("cacheable", cacheable);
        this.allProperties = null;
    }

    @Override
    public RecalculateEnum getRecalculate() {
        return (RecalculateEnum)((Object)this.getPropertyValue("recalculate"));
    }

    @Override
    public void setRecalculate(RecalculateEnum recalculate) {
        this.setFieldValue("recalculate", (Object)recalculate);
        this.allProperties = null;
    }

    @Override
    public String getPrecision() {
        return (String)this.getPropertyValue("precision");
    }

    @Override
    public void setPrecision(String precision) {
        this.setFieldValue("precision", precision);
        this.allProperties = null;
    }

    @Override
    public Boolean getAutoType() {
        return (Boolean)this.getPropertyValue("autoType");
    }

    @Override
    public void setAutoType(Boolean autoType) {
        this.setFieldValue("autoType", autoType);
        this.allProperties = null;
    }

    @Override
    public Boolean getParallel() {
        return (Boolean)this.getPropertyValue("parallel");
    }

    @Override
    public void setParallel(Boolean parallel) {
        this.setFieldValue("parallel", parallel);
        this.allProperties = null;
    }

    @Override
    public String getNature() {
        return (String)this.getPropertyValue("nature");
    }

    @Override
    public void setNature(String nature) {
        this.setFieldValue("nature", nature);
        this.allProperties = null;
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.getAllProperties().get(key);
    }

    @Override
    public String getPropertyValueAsString(String key) {
        String result = null;
        Object propValue = this.getPropertyValue(key);
        if (propValue != null) {
            if (propValue instanceof Date) {
                String format = TablePropertyDefinitionUtils.getPropertyByName(key).getFormat();
                if (format != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    result = dateFormat.format((Date)propValue);
                }
            } else if (EnumUtils.isEnum((Object)propValue)) {
                result = ((Enum)propValue).name();
            } else if (EnumUtils.isEnumArray((Object)propValue)) {
                Object[] enums = (Object[])propValue;
                if (!ArrayTool.isEmpty((Object[])enums)) {
                    Object[] names = EnumUtils.getNames((Object[])enums);
                    result = StringUtils.join((Object[])names, (String)",");
                } else {
                    result = "";
                }
            } else {
                result = propValue.toString();
            }
        }
        return result;
    }

    @Override
    public InheritanceLevel getPropertyLevelDefinedOn(String propertyName) {
        InheritanceLevel result = null;
        if (this.getPropertiesDefinedInTable().containsKey(propertyName)) {
            result = InheritanceLevel.TABLE;
        } else if (this.getPropertiesAppliedForCategory().containsKey(propertyName)) {
            result = InheritanceLevel.CATEGORY;
        } else if (this.getPropertiesAppliedForModule().containsKey(propertyName)) {
            result = InheritanceLevel.MODULE;
        } else if (this.getExternalPropertiesAppliedForModule().containsKey(propertyName)) {
            result = InheritanceLevel.EXTERNAL;
        }
        return result;
    }

    @Override
    public boolean isPropertyAppliedByDefault(String propertyName) {
        boolean result = false;
        if (this.getPropertyLevelDefinedOn(propertyName) == null && this.defaultProperties.containsKey(propertyName)) {
            result = true;
        }
        return result;
    }

    @Override
    public ILogicalTable getPropertiesSection() {
        return this.propertySection;
    }

    @Override
    public void setPropertiesSection(ILogicalTable propertySection) {
        this.propertySection = propertySection;
    }

    @Override
    public ILogicalTable getModulePropertiesTable() {
        return this.modulePropertiesTable;
    }

    @Override
    public void setModulePropertiesTable(ILogicalTable modulePropertiesTable) {
        this.modulePropertiesTable = modulePropertiesTable;
    }

    @Override
    public ILogicalTable getCategoryPropertiesTable() {
        return this.categoryPropertiesTable;
    }

    @Override
    public void setCategoryPropertiesTable(ILogicalTable categoryPropertiesTable) {
        this.categoryPropertiesTable = categoryPropertiesTable;
    }

    @Override
    public ILogicalTable getInheritedPropertiesTable(InheritanceLevel inheritanceLevel) {
        if (InheritanceLevel.MODULE.equals((Object)inheritanceLevel)) {
            return this.modulePropertiesTable;
        }
        if (InheritanceLevel.CATEGORY.equals((Object)inheritanceLevel)) {
            return this.categoryPropertiesTable;
        }
        return null;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        Map<String, Object> tableAndCategoryProp = this.mergeLevelProperties(super.getFieldValues(), this.categoryProperties);
        Map<String, Object> tableAndCategoryAndModuleProp = this.mergeLevelProperties(tableAndCategoryProp, this.moduleProperties);
        Map<String, Object> tableAndCategoryAndModuleAndExteranlProp = this.mergeLevelProperties(tableAndCategoryAndModuleProp, this.externalModuleProperties);
        Map<String, Object> allTableProperties = this.mergeLevelProperties(tableAndCategoryAndModuleAndExteranlProp, this.defaultProperties);
        this.allProperties = Collections.unmodifiableMap(allTableProperties);
        return this.allProperties;
    }

    public void setFieldValue(String name, Object value) {
        PropertiesChecker.isPropertySuitableForLevel(InheritanceLevel.TABLE, name);
        PropertiesChecker.isPropertySuitableForTableType(name, this.currentTableType);
        super.setFieldValue(name, value);
    }

    @Override
    public Map<String, Object> getPropertiesDefinedInTable() {
        return super.getFieldValues();
    }

    @Override
    public Map<String, Object> getAllDimensionalProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> props = this.getAllProperties();
        for (Map.Entry<String, Object> property : props.entrySet()) {
            String propName = property.getKey();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propName);
            if (!propertyDefinition.isDimensional()) continue;
            result.put(propName, property.getValue());
        }
        return result;
    }

    @Override
    public Map<String, Object> getPropertiesDefinedInTableIgnoreSystem() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> propDefinedInTable = this.getPropertiesDefinedInTable();
        for (Map.Entry<String, Object> property : propDefinedInTable.entrySet()) {
            String propName = property.getKey();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propName);
            if (propertyDefinition.isSystem()) continue;
            result.put(propName, property.getValue());
        }
        return result;
    }

    @Override
    public void setPropertiesAppliedForCategory(Map<String, Object> categoryProperties) {
        this.categoryProperties = categoryProperties;
        this.allProperties = null;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedForCategory() {
        return this.categoryProperties;
    }

    @Override
    public void setPropertiesAppliedForModule(Map<String, Object> moduleProperties) {
        this.moduleProperties = moduleProperties;
        this.allProperties = null;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedForModule() {
        return this.moduleProperties;
    }

    @Override
    public void setPropertiesAppliedByDefault(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
        this.allProperties = null;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedByDefault() {
        return this.defaultProperties;
    }

    @Override
    public void setCurrentTableType(String currentTableType) {
        this.currentTableType = currentTableType;
    }

    @Override
    public String getCurrentTableType() {
        return this.currentTableType;
    }

    @Override
    public Map<String, Object> getExternalPropertiesAppliedForModule() {
        return this.externalModuleProperties;
    }

    @Override
    public void setExternalPropertiesAppliedForModule(Map<String, Object> moduleProperties) {
        this.externalModuleProperties = moduleProperties;
        this.allProperties = null;
    }

    @Override
    public boolean isPropertiesEmpty() {
        Set<String> keys = this.getAllProperties().keySet();
        for (String key : keys) {
            if (this.getAllProperties().get(key) == null) continue;
            return false;
        }
        return true;
    }
}

