/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.inherit;

import java.util.Arrays;
import java.util.Set;
import org.openl.binding.impl.BindHelper;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesChecker {
    public static void checkProperties(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode, InheritanceLevel level) {
        PropertiesChecker.checkForErrors(propertyNamesToCheck, tableSyntaxNode, level);
        PropertiesChecker.checkForDeprecation(propertyNamesToCheck, tableSyntaxNode);
    }

    private static void checkForErrors(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode, InheritanceLevel level) {
        String tableType = tableSyntaxNode.getType();
        String typeName = PropertiesChecker.getTypeName(tableSyntaxNode);
        for (String propertyNameToCheck : propertyNamesToCheck) {
            String message;
            if (!PropertiesChecker.isPropertySuitableForTableType(propertyNameToCheck, tableType)) {
                message = String.format("Property '%s' can't be defined in %s Table", propertyNameToCheck, typeName);
                PropertiesChecker.addError(tableSyntaxNode, message);
                continue;
            }
            if (level == null || PropertiesChecker.isPropertySuitableForLevel(level, propertyNameToCheck)) continue;
            message = String.format("Property '%s' can't be defined on the '%s' level", propertyNameToCheck, level.getDisplayName());
            PropertiesChecker.addError(tableSyntaxNode, message);
        }
    }

    private static void addError(TableSyntaxNode tableSyntaxNode, String message) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        tableSyntaxNode.addError(error);
        BindHelper.processError((SyntaxNodeException)error);
    }

    private static void checkForDeprecation(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        for (String propertyNameToCheck : propertyNamesToCheck) {
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyNameToCheck);
            if (propertyDefinition == null || propertyDefinition.getDeprecation() == null || propertyDefinition.getDeprecation().isEmpty()) continue;
            String message = String.format("Property '%s' was deprecated. Please remove it!", propertyNameToCheck);
            OpenLMessagesUtils.addWarn((String)message, (ISyntaxNode)tableSyntaxNode);
        }
    }

    public static boolean isPropertySuitableForLevel(InheritanceLevel currentLevel, String propertyName) {
        Logger log = LoggerFactory.getLogger(PropertiesChecker.class);
        boolean result = false;
        TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propertyDefinition != null) {
            InheritanceLevel[] inheritanceLevels = propertyDefinition.getInheritanceLevel();
            if (inheritanceLevels != null && inheritanceLevels.length > 0) {
                if (Arrays.asList(inheritanceLevels).contains((Object)currentLevel)) {
                    result = true;
                }
            } else {
                log.debug("Inheritance levels were not defined for property with name [{}].", (Object)propertyName);
            }
        } else {
            log.debug("There is no such property in Definitions with name [{}].", (Object)propertyName);
        }
        return result;
    }

    public static boolean isPropertySuitableForTableType(String propertyName, String tableType) {
        XlsNodeTypes[] definitionTableTypes = TablePropertyDefinitionUtils.getSuitableTableTypes(propertyName);
        if (definitionTableTypes != null && definitionTableTypes.length > 0) {
            for (XlsNodeTypes nodeType : definitionTableTypes) {
                if (!nodeType.toString().equals(tableType)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static String getTypeName(TableSyntaxNode tableSyntaxNode) {
        switch (tableSyntaxNode.getNodeType()) {
            case XLS_DT: {
                return "Decision";
            }
            case XLS_SPREADSHEET: {
                return "Spreadsheet";
            }
            case XLS_TBASIC: {
                return "TBasic";
            }
            case XLS_COLUMN_MATCH: {
                return "Column Match";
            }
            case XLS_METHOD: {
                return "Method";
            }
            case XLS_TEST_METHOD: {
                return "Test";
            }
            case XLS_RUN_METHOD: {
                return "Run";
            }
            case XLS_DATA: {
                return "Data";
            }
            case XLS_DATATYPE: {
                return "Datatype";
            }
            case XLS_OPENL: {
                return "OpenL";
            }
            case XLS_ENVIRONMENT: {
                return "Environment";
            }
            case XLS_TABLEPART: {
                return "TablePart";
            }
            case XLS_OTHER: {
                return "Other";
            }
            case XLS_PROPERTIES: {
                return "Properties";
            }
        }
        return tableSyntaxNode.getNodeType().name();
    }
}

