/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui;

import org.openl.rules.table.AGrid;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.IGridFilter;

public class FilteredGrid
extends AGrid {
    private IGridFilter[] formatFilters;
    private IGrid delegate;

    public FilteredGrid(IGrid delegate, IGridFilter[] formatFilters) {
        this.delegate = delegate;
        this.formatFilters = (IGridFilter[])formatFilters.clone();
    }

    private void formatCell(FormattedCell fcell, int col, int row) {
        if (this.formatFilters != null) {
            for (int i = 0; i < this.formatFilters.length; ++i) {
                IGridSelector selector = this.formatFilters[i].getGridSelector();
                if (selector != null && !selector.selectCoords(col, row)) continue;
                try {
                    this.formatFilters[i].filterFormat(fcell);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public ICell getCell(int column, int row) {
        if (this.isEmpty(column, row)) {
            this.delegate.getCell(column, row);
        }
        return this.getFormattedCell(column, row);
    }

    public synchronized FormattedCell getFormattedCell(int col, int row) {
        ICell cell = this.delegate.getCell(col, row);
        FormattedCell cellToFormat = new FormattedCell(cell);
        this.formatCell(cellToFormat, col, row);
        return cellToFormat;
    }

    @Override
    public int getColumnWidth(int col) {
        return this.delegate.getColumnWidth(col);
    }

    @Override
    public int getMaxColumnIndex(int row) {
        return this.delegate.getMaxColumnIndex(row);
    }

    @Override
    public int getMaxRowIndex() {
        return this.delegate.getMaxRowIndex();
    }

    @Override
    public IGridRegion getMergedRegion(int i) {
        return this.delegate.getMergedRegion(i);
    }

    @Override
    public int getMinColumnIndex(int row) {
        return this.delegate.getMaxColumnIndex(row);
    }

    @Override
    public int getMinRowIndex() {
        return this.delegate.getMinRowIndex();
    }

    @Override
    public int getNumberOfMergedRegions() {
        return this.delegate.getNumberOfMergedRegions();
    }

    @Override
    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        return this.delegate.getRangeUri(colStart, rowStart, colEnd, rowEnd);
    }

    @Override
    public IGridRegion getRegionStartingAt(int colFrom, int rowFrom) {
        return this.delegate.getRegionStartingAt(colFrom, rowFrom);
    }

    @Override
    public String getUri() {
        return this.delegate.getUri();
    }

    @Override
    public boolean isEmpty(int col, int row) {
        return this.delegate.isEmpty(col, row);
    }

    @Override
    public boolean isPartOfTheMergedRegion(int col, int row) {
        return this.delegate.isPartOfTheMergedRegion(col, row);
    }

    @Override
    public IGridRegion getRegionContaining(int column, int row) {
        return this.delegate.getRegionContaining(column, row);
    }
}

