/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.AGridFilter;

public class CellStyleGridFilter
extends AGridFilter {
    private static final int BORDER_SIDES_COUNT = 4;
    private BorderStyle[] borderStyle;
    private short[][] borderRGB;

    protected CellStyleGridFilter(IGridSelector selector, BorderStyle[] borderStyle, short[][] borderRGB) {
        super(selector);
        this.borderStyle = borderStyle;
        this.borderRGB = borderRGB;
    }

    private CellStyleGridFilter(Builder builder) {
        this(builder.selector, builder.borderStyle, builder.borderRGB);
    }

    @Override
    public FormattedCell filterFormat(FormattedCell cell) {
        CellStyle style = (CellStyle)cell.getStyle();
        if (this.borderStyle != null) {
            if (style.getBorderStyle() != null) {
                for (int i = 0; i < this.borderStyle.length; ++i) {
                    BorderStyle border = this.borderStyle[i];
                    if (border != null) continue;
                    this.borderStyle[i] = style.getBorderStyle()[i];
                }
            }
            style.setBorderStyle(this.borderStyle);
        }
        if (this.borderRGB != null) {
            style.setBorderRGB(this.borderRGB);
        }
        return cell;
    }

    public CellStyleGridFilter createUpperRowBorderFilter() {
        IGridSelector upperRowSelector = new IGridSelector(){

            @Override
            public boolean selectCoords(int col, int row) {
                return CellStyleGridFilter.this.getGridSelector().selectCoords(col, row + 1) && !CellStyleGridFilter.this.getGridSelector().selectCoords(col, row);
            }
        };
        BorderStyle[] bottomBorderStyle = new BorderStyle[4];
        bottomBorderStyle[2] = BorderStyle.NONE;
        short[][] bottomRGB = new short[4][];
        bottomRGB[2] = this.borderRGB[0];
        return new Builder().setSelector(upperRowSelector).setBorderStyle(bottomBorderStyle).setBorderRGB(bottomRGB).build();
    }

    public CellStyleGridFilter createLefterColumnBorderFilter() {
        IGridSelector upperRowSelector = new IGridSelector(){

            @Override
            public boolean selectCoords(int col, int row) {
                return CellStyleGridFilter.this.getGridSelector().selectCoords(col + 1, row) && !CellStyleGridFilter.this.getGridSelector().selectCoords(col, row);
            }
        };
        BorderStyle[] bottomBorderStyle = new BorderStyle[4];
        bottomBorderStyle[1] = BorderStyle.NONE;
        short[][] bottomRGB = new short[4][];
        bottomRGB[1] = this.borderRGB[3];
        return new Builder().setSelector(upperRowSelector).setBorderStyle(bottomBorderStyle).setBorderRGB(bottomRGB).build();
    }

    public static class Builder {
        private IGridSelector selector;
        private BorderStyle[] borderStyle;
        private short[][] borderRGB;

        public Builder setSelector(IGridSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException("selector can't be null");
            }
            this.selector = selector;
            return this;
        }

        public Builder setBorderStyle(BorderStyle[] borderStyle) {
            if (borderStyle == null) {
                throw new IllegalArgumentException("borderStyle can't be null");
            }
            this.borderStyle = borderStyle;
            return this;
        }

        public Builder setBorderStyle(BorderStyle borderStyles) {
            return this.setBorderStyle(this.createBorderStyle(borderStyles));
        }

        public Builder setBorderRGB(short[][] borderRGB) {
            if (borderRGB == null) {
                throw new IllegalArgumentException("borderRGB can't be null");
            }
            this.borderRGB = borderRGB;
            return this;
        }

        public Builder setBorderRGB(short[] rgb) {
            if (rgb == null) {
                throw new IllegalArgumentException("rgb can't be null");
            }
            return this.setBorderRGB(this.createBorderRGB(rgb));
        }

        public CellStyleGridFilter build() {
            return new CellStyleGridFilter(this);
        }

        private BorderStyle[] createBorderStyle(BorderStyle style) {
            BorderStyle[] colors = new BorderStyle[4];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = style;
            }
            return colors;
        }

        private short[][] createBorderRGB(short[] rgb) {
            short[][] colors = new short[4][];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = rgb;
            }
            return colors;
        }
    }
}

