/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.xls.PoiExcelHelper;

public class XlsCellFont
implements ICellFont {
    private Font font;
    private Workbook workbook;

    public XlsCellFont(Font font, Workbook workbook) {
        this.font = font;
        this.workbook = workbook;
    }

    @Override
    public short[] getFontColor() {
        return PoiExcelHelper.getFontColor(this.font, this.workbook);
    }

    @Override
    public String getName() {
        return this.font.getFontName();
    }

    @Override
    public int getSize() {
        return this.font.getFontHeightInPoints();
    }

    @Override
    public boolean isBold() {
        return this.font.getBold();
    }

    @Override
    public boolean isItalic() {
        return this.font.getItalic();
    }

    @Override
    public boolean isStrikeout() {
        return this.font.getStrikeout();
    }

    @Override
    public boolean isUnderlined() {
        return this.font.getUnderline() != 0;
    }
}

