/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;
import org.openl.util.StringUtils;

public class DatatypeTableBuilder
extends TableBuilder {
    public static final int MIN_WIDTH = 2;

    public void beginTable(int height) throws CreateTableException {
        super.beginTable(2, height);
    }

    public DatatypeTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    @Override
    public void writeHeader(String tableName, ICellStyle style) {
        this.writeHeader(tableName, null, style);
    }

    public void writeHeader(String tableName, String parentType, ICellStyle style) {
        String header = "Datatype";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            header = header + " " + tableName;
        }
        if (StringUtils.isNotBlank((CharSequence)parentType)) {
            header = header + " extends " + parentType;
        }
        super.writeHeader(header, style);
    }

    public void writeHeader(String tableName, String parentType) {
        this.writeHeader(tableName, parentType, null);
    }

    public void writeParameter(String paramType, String paramName, ICellStyle cellStyle) {
        if (StringUtils.isBlank((CharSequence)paramType) || StringUtils.isBlank((CharSequence)paramName)) {
            throw new IllegalArgumentException("Parameter type and name must be not empty");
        }
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        this.writeCell(0, this.getCurrentRow(), 1, 1, paramType, cellStyle);
        this.writeCell(1, this.getCurrentRow(), 1, 1, paramName, cellStyle);
        this.incCurrentRow();
    }

    public void writeParameter(String paramType, String paramName) {
        this.writeParameter(paramType, paramName, null);
    }
}

