/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.NoParamMethodField;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.AlgorithmFunctionCompiler;
import org.openl.rules.tbasic.compile.AlgorithmOpenClass;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.rules.tbasic.compile.OperationType;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.DynamicObjectField;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

public class AlgorithmCompiler {
    private IBindingContext context;
    private IOpenMethodHeader header;
    private List<AlgorithmTreeNode> nodesToCompile;
    private CompileContext mainCompileContext;
    private List<AlgorithmFunctionCompiler> functions = new ArrayList<AlgorithmFunctionCompiler>();
    private LabelManager labelManager;
    private AlgorithmOpenClass thisTargetClass;
    private IBindingContext thisContext;
    private Map<String, OperationPreprocessor> operationPreprocessors = new HashMap<String, OperationPreprocessor>();
    private Stack<Collection<IOpenField>> variablesStack = new Stack();

    public AlgorithmCompiler(IBindingContext context, IOpenMethodHeader header, List<AlgorithmTreeNode> nodesToCompile) {
        this.operationPreprocessors.put(OperationType.COMPILE.toString(), new CompilePreprocessor());
        this.operationPreprocessors.put(OperationType.DECLARE.toString(), new DeclarePreprocessor());
        this.operationPreprocessors.put(OperationType.DECLARE_ARRAY_ELEMENT.toString(), new DeclareArrayElementPreprocessor());
        this.operationPreprocessors.put(OperationType.SUBROUTINE.toString(), new DeclareSubroutinePreprocessor());
        this.operationPreprocessors.put(OperationType.FUNCTION.toString(), new DeclareFunctionPreprocessor());
        this.context = context;
        this.header = header;
        this.nodesToCompile = nodesToCompile;
    }

    public void compile(Algorithm algorithm) throws Exception {
        this.initialization(algorithm);
        this.precompile();
        this.compile();
        this.postprocess(algorithm);
    }

    private void compile() throws Exception {
        this.getThisTargetClass().allFieldsToVisible();
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.compile();
        }
    }

    private void createAlgorithmInternalMethod(List<AlgorithmTreeNode> nodesToCompile, IOpenClass returnType, CompileContext methodContext) throws SyntaxNodeException {
        for (StringValue label : nodesToCompile.get(0).getLabels()) {
            String methodName = label.getValue();
            OpenMethodHeader methodHeader = new OpenMethodHeader(methodName, returnType, IMethodSignature.VOID, (IOpenClass)this.thisTargetClass);
            AlgorithmSubroutineMethod method = new AlgorithmSubroutineMethod((IOpenMethodHeader)methodHeader);
            this.thisTargetClass.addMethod((IOpenMethod)method);
            NoParamMethodField methodAlternative = new NoParamMethodField(methodName, method);
            this.thisTargetClass.addField(methodAlternative);
            this.functions.add(new AlgorithmFunctionCompiler(nodesToCompile, methodContext, method, this));
        }
        Map<String, AlgorithmTreeNode> internalLablesOfMethod = AlgorithmCompilerTool.getAllDeclaredLables(nodesToCompile);
        methodContext.registerGroupOfLabels(internalLablesOfMethod);
    }

    private IBindingContext getAlgorithmBindingContext() {
        if (this.thisContext == null) {
            this.thisContext = new ComponentBindingContext(this.context, (ComponentOpenClass)this.thisTargetClass);
        }
        return this.thisContext;
    }

    private void declareFunction(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep convertionStep) throws SyntaxNodeException {
        String returnValueInstruction = convertionStep.getOperationParam1();
        IOpenClass returnType = AlgorithmCompilerTool.isOperationFieldInstruction(returnValueInstruction) ? this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, returnValueInstruction)) : this.discoverFunctionType(nodesToCompile.get(0).getChildren(), returnValueInstruction);
        this.createAlgorithmInternalMethod(nodesToCompile, returnType, new CompileContext());
    }

    private void declareSubroutine(List<AlgorithmTreeNode> nodesToCompile) throws SyntaxNodeException {
        CompileContext subroutineContext = new CompileContext();
        subroutineContext.registerGroupOfLabels(this.mainCompileContext.getExistingLables());
        this.createAlgorithmInternalMethod(nodesToCompile, (IOpenClass)JavaOpenClass.VOID, subroutineContext);
    }

    private void declareVariable(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
        String variableNameParameter = conversionStep.getOperationParam1();
        String variableAssignmentParameter = conversionStep.getOperationParam2();
        StringValue variableName = AlgorithmCompilerTool.getCellContent(nodesToCompile, variableNameParameter);
        IOpenClass variableType = this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, variableAssignmentParameter));
        this.initNewInternalVariable(variableName.getValue(), variableType);
    }

    private void declareArrayElement(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
        String elementNameParameter = conversionStep.getOperationParam1();
        String iterableArrayParameter = conversionStep.getOperationParam2();
        StringValue elementName = AlgorithmCompilerTool.getCellContent(nodesToCompile, elementNameParameter);
        IOpenClass iterableArrayType = this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, iterableArrayParameter));
        if (!iterableArrayType.isArray()) {
            IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getAction().asSourceCodeModule();
            throw SyntaxNodeExceptionUtils.createError((String)"Compilation failure. The cell should be of the array type", (IOpenSourceCodeModule)errorSource);
        }
        IOpenClass elementType = iterableArrayType.getComponentClass();
        this.initNewInternalVariable(elementName.getValue(), elementType);
    }

    private IOpenClass discoverFunctionType(List<AlgorithmTreeNode> children, String returnValueInstruction) throws SyntaxNodeException {
        List<AlgorithmTreeNode> returnNodes = this.findFirstReturn(children);
        if (returnNodes == null || returnNodes.size() == 0) {
            StringValue lastAction = AlgorithmCompilerTool.getLastExecutableOperation(children).getAlgorithmRow().getAction();
            return this.getTypeOfField(lastAction);
        }
        String fieldWithOpenLStatement = "RETURN.condition";
        return this.getTypeOfField(AlgorithmCompilerTool.getCellContent(returnNodes, fieldWithOpenLStatement));
    }

    private List<AlgorithmTreeNode> findFirstReturn(List<AlgorithmTreeNode> nodes) {
        List<AlgorithmTreeNode> returnNodeSubList = null;
        for (int i = 0; i < nodes.size() && returnNodeSubList == null; ++i) {
            if (TBasicSpecificationKey.RETURN.toString().equals(nodes.get(i).getSpecificationKeyword())) {
                returnNodeSubList = nodes.subList(i, i + 1);
                continue;
            }
            if (nodes.get(i).getChildren() == null) continue;
            returnNodeSubList = this.findFirstReturn(nodes.get(i).getChildren());
        }
        return returnNodeSubList;
    }

    private String generateOpenClassName() {
        return this.header.getName();
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    private List<AlgorithmTreeNode> getMainFunctionBody() {
        int currentOperationIndex;
        for (currentOperationIndex = 0; currentOperationIndex < this.nodesToCompile.size() && !TBasicSpecificationKey.FUNCTION.toString().equals(this.nodesToCompile.get(currentOperationIndex).getSpecificationKeyword()) && !TBasicSpecificationKey.SUB.toString().equals(this.nodesToCompile.get(currentOperationIndex).getSpecificationKeyword()); ++currentOperationIndex) {
        }
        return this.nodesToCompile.subList(0, currentOperationIndex);
    }

    public AlgorithmOpenClass getThisTargetClass() {
        return this.thisTargetClass;
    }

    public IOpenClass getTypeOfField(StringValue fieldContent) {
        IOpenSourceCodeModule src = fieldContent.asSourceCodeModule();
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        return OpenLCellExpressionsCompiler.makeMethodWithUnknownType(openl, src, "cell_" + fieldContent.getValue(), signature, (IOpenClass)this.thisTargetClass, this.getAlgorithmBindingContext()).getMethod().getType();
    }

    private void initialization(Algorithm algorithm) throws SyntaxNodeException {
        this.labelManager = new LabelManager();
        this.thisTargetClass = new AlgorithmOpenClass(this.generateOpenClassName(), this.context.getOpenL());
        this.variablesStack.push(new ArrayList());
        this.initNewInternalVariable("ERROR", this.getTypeOfField(new StringValue("new RuntimeException()")));
        this.initNewInternalVariable("Error Message", this.getTypeOfField(new StringValue("\"Error!\"")));
        this.mainCompileContext = new CompileContext();
        List<AlgorithmTreeNode> mainFunction = this.getMainFunctionBody();
        this.mainCompileContext.registerGroupOfLabels(AlgorithmCompilerTool.getAllDeclaredLables(mainFunction));
        this.functions.add(new AlgorithmFunctionCompiler(mainFunction, this.mainCompileContext, algorithm, this));
    }

    private void initNewInternalVariable(String variableName, IOpenClass variableType) {
        DynamicObjectField field = new DynamicObjectField((IOpenClass)this.thisTargetClass, variableName, variableType);
        this.getThisTargetClass().addField((IOpenField)field);
        this.variablesStack.peek().add((IOpenField)field);
    }

    public IMethodCaller makeMethod(IOpenSourceCodeModule src, String methodName) {
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        IBindingContext cxt = this.getAlgorithmBindingContext();
        return OpenLCellExpressionsCompiler.makeMethodWithUnknownType(openl, src, methodName, signature, (IOpenClass)this.thisTargetClass, cxt);
    }

    public IMethodCaller makeMethodWithCast(IOpenSourceCodeModule src, String methodName, IOpenClass returnType) {
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        OpenMethodHeader header = new OpenMethodHeader(methodName, returnType, signature, (IOpenClass)this.thisTargetClass);
        IBindingContext cxt = this.getAlgorithmBindingContext();
        return OpenLCellExpressionsCompiler.makeMethod(openl, src, (IOpenMethodHeader)header, cxt);
    }

    private void postprocess(Algorithm algorithm) {
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.postprocess();
        }
        algorithm.setThisClass((IOpenClass)this.getThisTargetClass());
    }

    private void precompile() throws SyntaxNodeException {
        this.precompileNestedNodes(this.nodesToCompile);
    }

    private void precompileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile) throws SyntaxNodeException {
        assert (nodesToCompile.size() > 0);
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile);
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            this.preprocessConversionStep(nodesToCompile, convertionStep);
        }
    }

    private void precompileNestedNodes(List<AlgorithmTreeNode> nodesToProcess) throws SyntaxNodeException {
        int linkedNodesGroupSize;
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            this.precompileLinkedNodesGroup(nodesToCompile);
        }
    }

    private void preprocessConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
        assert (nodesToCompile.size() > 0);
        assert (conversionStep != null);
        String operationType = conversionStep.getOperationType();
        if (operationType.startsWith("!") && !operationType.equals(OperationType.CHECK_LABEL.toString())) {
            OperationPreprocessor preprocessor = this.operationPreprocessors.get(operationType);
            if (preprocessor == null) {
                IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Unknown compilation instruction %s", operationType), (IOpenSourceCodeModule)errorSource);
            }
            preprocessor.preprocess(nodesToCompile, conversionStep);
        }
    }

    private final void updateVariablesVisibitily(Collection<IOpenField> fields) {
        for (IOpenField field : fields) {
            this.thisTargetClass.setFieldToInvisibleState(field.getName());
        }
    }

    private final class DeclareFunctionPreprocessor
    implements OperationPreprocessor {
        private DeclareFunctionPreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
            AlgorithmCompiler.this.declareFunction(nodesToCompile, conversionStep);
        }
    }

    private final class DeclareSubroutinePreprocessor
    implements OperationPreprocessor {
        private DeclareSubroutinePreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
            AlgorithmCompiler.this.declareSubroutine(nodesToCompile);
        }
    }

    private final class DeclareArrayElementPreprocessor
    implements OperationPreprocessor {
        private DeclareArrayElementPreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
            AlgorithmCompiler.this.declareArrayElement(nodesToCompile, conversionStep);
        }
    }

    private final class DeclarePreprocessor
    implements OperationPreprocessor {
        private DeclarePreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
            AlgorithmCompiler.this.declareVariable(nodesToCompile, conversionStep);
        }
    }

    private final class CompilePreprocessor
    implements OperationPreprocessor {
        private CompilePreprocessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
            List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1());
            try {
                AlgorithmCompiler.this.variablesStack.push(new ArrayList());
                AlgorithmCompiler.this.precompileNestedNodes(nodesToProcess);
            }
            finally {
                AlgorithmCompiler.this.updateVariablesVisibitily((Collection)AlgorithmCompiler.this.variablesStack.pop());
            }
        }
    }

    public static interface OperationPreprocessor {
        public void preprocess(List<AlgorithmTreeNode> var1, ConversionRuleStep var2) throws SyntaxNodeException;
    }
}

