/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.types.IOpenField;

public class AlgorithmOpenClass
extends ComponentOpenClass {
    private Set<String> invisibleFields = new HashSet<String>();

    public AlgorithmOpenClass(String name, OpenL openl) {
        super(name, openl);
    }

    public IOpenField getField(String fname) {
        if (!this.invisibleFields.contains(fname)) {
            return super.getField(fname);
        }
        return null;
    }

    public IOpenField getField(String fname, boolean strictMatch) {
        if (!this.invisibleFields.contains(fname)) {
            return super.getField(fname, strictMatch);
        }
        return null;
    }

    public Map<String, IOpenField> getFields() {
        return this.filterFields(super.getFields());
    }

    private Map<String, IOpenField> filterFields(Map<String, IOpenField> fields) {
        HashMap<String, IOpenField> visibleFields = new HashMap<String, IOpenField>();
        for (Map.Entry<String, IOpenField> entry : fields.entrySet()) {
            if (this.invisibleFields.contains(entry.getKey())) continue;
            visibleFields.put(entry.getKey(), entry.getValue());
        }
        return visibleFields;
    }

    public Map<String, IOpenField> getDeclaredFields() {
        return this.filterFields(super.getDeclaredFields());
    }

    public void setFieldToInvisibleState(String fname) {
        this.invisibleFields.add(fname);
    }

    public void setFieldToVisibleState(String fname) {
        this.invisibleFields.remove(fname);
    }

    public void allFieldsToVisible() {
        this.invisibleFields.clear();
    }
}

