/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.List;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.RulesRuntimeContextFactory;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestUnit;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DynamicObject;
import org.openl.util.Log;
import org.openl.vm.IRuntimeEnv;

public class TestDescription {
    private ParameterWithValueDeclaration[] executionParams;
    private IOpenMethod testedMethod;
    private DynamicObject testObject;
    private int index;
    private ColumnDescriptor[] columnDescriptors;
    private List<IOpenField> fields;
    private OpenLArgumentsCloner cloner = new OpenLArgumentsCloner();

    public TestDescription(IOpenMethod testedMethod, DynamicObject testObject, List<IOpenField> fields, ColumnDescriptor[] columnDescriptors) {
        this.testedMethod = testedMethod;
        this.testObject = testObject;
        this.fields = fields;
        this.columnDescriptors = columnDescriptors;
        this.executionParams = TestDescription.initExecutionParams(testedMethod, testObject);
    }

    public TestDescription(IOpenMethod testedMethod, Object[] arguments) {
        this.testedMethod = testedMethod;
        this.testObject = TestDescription.createTestObject(testedMethod, arguments);
        this.executionParams = TestDescription.initExecutionParams(testedMethod, this.testObject);
    }

    private static DynamicObject createTestObject(IOpenMethod testedMethod, Object[] arguments) {
        DynamicObject testObj = new DynamicObject();
        IMethodSignature signature = testedMethod.getSignature();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String paramName = signature.getParameterName(i);
            testObj.setFieldValue(paramName, arguments[i]);
        }
        return testObj;
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    public DynamicObject getTestObject() {
        return this.testObject;
    }

    public ParameterWithValueDeclaration[] getExecutionParams() {
        return this.executionParams;
    }

    public String[] getParametersNames() {
        String[] names = new String[this.executionParams.length];
        for (int i = 0; i < this.executionParams.length; ++i) {
            names[i] = this.executionParams[i].getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getArguments() {
        Object[] args = new Object[this.executionParams.length];
        for (int i = 0; i < args.length; ++i) {
            Object value = this.executionParams[i].getValue();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (value != null) {
                    Thread.currentThread().setContextClassLoader(value.getClass().getClassLoader());
                }
                try {
                    args[i] = this.cloner.deepClone(value);
                }
                catch (RuntimeException e) {
                    Log.error((String)"Failed to clone an argument \"{0}\". Original argument will be used.", (Object[])new Object[]{this.executionParams[i].getName()});
                    args[i] = value;
                }
                continue;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return args;
    }

    private static ParameterWithValueDeclaration[] initExecutionParams(IOpenMethod testedMethod, DynamicObject testObject) {
        ParameterWithValueDeclaration[] executionParams = new ParameterWithValueDeclaration[testedMethod.getSignature().getNumberOfParameters()];
        for (int i = 0; i < executionParams.length; ++i) {
            String paramName = testedMethod.getSignature().getParameterName(i);
            Object paramValue = testObject.getFieldValue(paramName);
            IOpenClass paramType = testedMethod.getSignature().getParameterType(i);
            executionParams[i] = new ParameterWithValueDeclaration(paramName, paramValue, paramType);
        }
        return executionParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestUnit runTest(Object target, IRuntimeEnv env, long ntimes) {
        long end;
        if (ntimes <= 0L) {
            return this.runTest(target, env, 1L);
        }
        Object res = null;
        Throwable exception = null;
        IRuntimeContext oldContext = env.getContext();
        long start = System.nanoTime();
        try {
            IRulesRuntimeContext context = this.getRuntimeContext();
            env.setContext((IRuntimeContext)context);
            Object[] args = this.getArguments();
            start = System.nanoTime();
            int j = 0;
            while ((long)j < ntimes) {
                res = this.testedMethod.invoke(target, args, env);
                ++j;
            }
            end = System.nanoTime();
        }
        catch (Throwable t) {
            end = System.nanoTime();
            exception = t;
        }
        finally {
            env.setContext(oldContext);
        }
        long time = end - start;
        return new TestUnit(this, res, exception, time);
    }

    private Object getArgumentValue(String paramName) {
        return this.testObject.getFieldValue(paramName);
    }

    public boolean hasDescription() {
        return this.testObject.containsField("_description_");
    }

    public String getDescription() {
        return (String)this.getArgumentValue("_description_");
    }

    public boolean isExpectedResultDefined() {
        return this.testObject.containsField("_res_") || this.testObject.getType().getField("_res_") != null;
    }

    public Object getExpectedResult() {
        return this.getArgumentValue("_res_");
    }

    public boolean isExpectedErrorDefined() {
        return this.testObject.containsField("_error_");
    }

    public String getExpectedError() {
        return (String)this.getArgumentValue("_error_");
    }

    public boolean isRuntimeContextDefined() {
        return this.testObject.containsField("_context_");
    }

    public IRulesRuntimeContext getRuntimeContext() {
        IRulesRuntimeContext context = (IRulesRuntimeContext)this.getArgumentValue("_context_");
        if (context == null) {
            return RulesRuntimeContextFactory.buildRulesRuntimeContext();
        }
        try {
            return (IRulesRuntimeContext)this.cloner.deepClone(context);
        }
        catch (Exception e) {
            Log.error((Object)"Failed to clone context. Original context will be used.");
            return context;
        }
    }

    public String getId() {
        if (this.hasId()) {
            return String.valueOf(this.getArgumentValue("_id_"));
        }
        return String.valueOf(this.index + 1);
    }

    public boolean hasId() {
        return this.testObject.containsField("_id_");
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public List<IOpenField> getFields() {
        return this.fields;
    }
}

