/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.openl.base.INamedThing;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestSuiteExecutor;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

public class TestSuite
implements INamedThing {
    public static String VIRTUAL_TEST_SUITE = "Virtual test suite";
    private TestSuiteMethod testSuiteMethod;
    private TestDescription[] tests;

    public TestSuite(TestSuiteMethod testSuiteMethod) {
        this.testSuiteMethod = testSuiteMethod;
        this.tests = testSuiteMethod.getTests();
    }

    public TestSuite(TestSuiteMethod testSuiteMethod, int ... testIndices) {
        this.testSuiteMethod = testSuiteMethod;
        this.tests = new TestDescription[testIndices.length];
        for (int i = 0; i < testIndices.length; ++i) {
            this.tests[i] = testSuiteMethod.getTest(testIndices[i]);
        }
    }

    public TestSuite(TestDescription ... tests) {
        this.tests = tests;
    }

    public TestSuiteMethod getTestSuiteMethod() {
        return this.testSuiteMethod;
    }

    public TestDescription[] getTests() {
        return this.tests;
    }

    public TestDescription getTest(int testNumber) {
        return this.tests[testNumber];
    }

    public TestUnitsResults invokeParallel(TestSuiteExecutor testSuiteExecutor, final IOpenClass openClass, final long ntimes) {
        final int THREAD_COUNT = testSuiteExecutor.getThreadCount();
        Executor threadPoolExecutor = testSuiteExecutor.getExecutor();
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        final CountDownLatch countDownLatch = new CountDownLatch(THREAD_COUNT);
        final TestUnit[] testUnitResultsArray = new TestUnit[this.getNumberOfTests()];
        int i22 = 0;
        while (i22 < THREAD_COUNT) {
            final int numThread = i22++;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int j = 0; j < TestSuite.this.getNumberOfTests(); ++j) {
                            if (j % THREAD_COUNT != numThread) continue;
                            testUnitResultsArray[j] = TestSuite.this.executeTest(openClass, j, ntimes);
                        }
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            };
            threadPoolExecutor.execute(runnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            testUnitResults.addTestUnit(testUnitResultsArray[i]);
        }
        return testUnitResults;
    }

    public TestUnitsResults invokeSequentially(IOpenClass openClass, long ntimes) {
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            TestUnit testUnit = this.executeTest(openClass, i, ntimes);
            testUnitResults.addTestUnit(testUnit);
        }
        return testUnitResults;
    }

    private TestUnit executeTest(IOpenClass openClass, int test, long ntimes) {
        TestDescription currentTest = this.getTest(test);
        SimpleRulesRuntimeEnv env = new SimpleRulesVM().getRuntimeEnv();
        Object target = openClass.newInstance((IRuntimeEnv)env);
        return currentTest.runTest(target, (IRuntimeEnv)env, ntimes);
    }

    public TestUnitsResults invoke(Object target, IRuntimeEnv env) {
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            TestDescription currentTest = this.getTest(i);
            testUnitResults.addTestUnit(currentTest.runTest(target, env, 1L));
        }
        return testUnitResults;
    }

    public int getNumberOfTests() {
        return this.tests.length;
    }

    public String getName() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getName();
        }
        return VIRTUAL_TEST_SUITE;
    }

    public boolean isVirtualTestSuite() {
        return this.testSuiteMethod == null;
    }

    public IOpenMethod getTestedMethod() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getTestedMethod();
        }
        return this.tests[0].getTestedMethod();
    }

    public String getDisplayName(int mode) {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getDisplayName(mode);
        }
        return this.getName();
    }

    public String getUri() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getSourceUrl();
        }
        return this.getTestedMethod().getInfo().getSourceUrl();
    }
}

