/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.data.PrecisionFieldChain;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.TestUtils;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class TestUnit {
    private TestDescription test;
    private Object expectedResult;
    private String expectedError;
    private Object actualResult;
    private Throwable actualError;
    public static final String DEFAULT_DESCRIPTION = "No Description";
    private List<ComparedResult> comparisonResults = new ArrayList<ComparedResult>();
    private TestStatus comapreResult;
    private final long executionTime;

    public TestUnit(TestDescription test, Object res, Throwable error, long executionTime) {
        this.test = test;
        this.executionTime = executionTime;
        this.expectedError = test.getExpectedError();
        this.expectedResult = test.getExpectedResult();
        this.actualResult = res;
        this.actualError = error;
        if (this.expectedError != null && this.expectedResult != null) {
            this.actualError = new IllegalArgumentException("Ambiguous expectation in the test case. Two expected result has been declared.");
        }
    }

    public Object getExpectedResult() {
        return this.expectedError == null ? this.expectedResult : this.expectedError;
    }

    public Object getActualResult() {
        return this.actualError == null ? this.actualResult : this.actualError;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public ParameterWithValueDeclaration getActualParam() {
        return new ParameterWithValueDeclaration("actual", this.getActualResult());
    }

    public ParameterWithValueDeclaration[] getContextParams(TestUnitsResults objTestResult) {
        return TestUtils.getContextParams(objTestResult.getTestSuite(), this.test);
    }

    public List<ComparedResult> getResultParams() {
        ArrayList<ComparedResult> params = new ArrayList<ComparedResult>();
        if (this.expectedError == null && this.actualError == null) {
            List<ComparedResult> results = this.comparisonResults;
            for (ComparedResult comparedResult : results) {
                if (!(comparedResult.getActualValue() instanceof ParameterWithValueDeclaration)) {
                    comparedResult.setActualValue(new ParameterWithValueDeclaration(comparedResult.getFieldName(), comparedResult.getActualValue()));
                }
                if (!(comparedResult.getExpectedValue() instanceof ParameterWithValueDeclaration)) {
                    comparedResult.setExpectedValue(new ParameterWithValueDeclaration(comparedResult.getFieldName(), comparedResult.getExpectedValue()));
                }
                params.add(comparedResult);
            }
            return params;
        }
        ComparedResult result = new ComparedResult();
        result.setStatus(this.compareResult());
        result.setActualValue(new ParameterWithValueDeclaration("actualResult", this.getActualResult()));
        result.setExpectedValue(new ParameterWithValueDeclaration("expectedResult", this.getExpectedResult()));
        params.add(result);
        return params;
    }

    public String getDescription() {
        String descr = this.test.getDescription();
        return descr == null ? DEFAULT_DESCRIPTION : descr;
    }

    public List<ComparedResult> getComparisonResults() {
        return this.comparisonResults;
    }

    public TestStatus compareResult() {
        if (this.comapreResult != null) {
            return this.comapreResult;
        }
        if (this.actualError != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.actualError);
            if (rootCause instanceof OpenLUserRuntimeException) {
                String actualMessage = rootCause.getMessage();
                this.comapreResult = actualMessage.equals(this.expectedError == null ? "" : this.expectedError) ? TestStatus.TR_OK : TestStatus.TR_NEQ;
            } else {
                this.comapreResult = TestStatus.TR_EXCEPTION;
            }
        } else {
            this.comapreResult = this.expectedError != null ? TestStatus.TR_NEQ : (this.isEqual(this.expectedResult, this.actualResult) ? TestStatus.TR_OK : TestStatus.TR_NEQ);
        }
        return this.comapreResult;
    }

    public TestDescription getTest() {
        return this.test;
    }

    public List<OpenLMessage> getErrors() {
        if (this.actualError != null) {
            return OpenLMessagesUtils.newMessages((Throwable)this.actualError);
        }
        return Collections.emptyList();
    }

    private boolean isEqual(Object expectedResult, Object actualResult) {
        boolean success = true;
        this.comparisonResults = new ArrayList<ComparedResult>();
        for (IOpenField field : this.test.getFields()) {
            Object actualFieldValue = this.getFieldValueOrNull(actualResult, field);
            Object expectedFieldValue = this.getFieldValueOrNull(expectedResult, field);
            Double columnDelta = null;
            if (field instanceof PrecisionFieldChain && ((PrecisionFieldChain)field).hasDelta()) {
                columnDelta = ((PrecisionFieldChain)field).getDelta();
            }
            Class clazz = field.getType().getInstanceClass();
            TestResultComparator comparator = TestResultComparatorFactory.getComparator(clazz, columnDelta);
            boolean equal = comparator.isEqual(expectedFieldValue, actualFieldValue);
            success = success && equal;
            ComparedResult fieldComparisonResults = new ComparedResult();
            fieldComparisonResults.setFieldName(field.getName());
            fieldComparisonResults.setActualValue(actualFieldValue);
            fieldComparisonResults.setExpectedValue(expectedFieldValue);
            fieldComparisonResults.setStatus(equal ? TestStatus.TR_OK : TestStatus.TR_NEQ);
            this.comparisonResults.add(fieldComparisonResults);
        }
        return success;
    }

    private Object getFieldValueOrNull(Object result, IOpenField field) {
        Object fieldValue = null;
        if (result != null) {
            try {
                IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
                fieldValue = field.get(result, env);
            }
            catch (Exception ex) {
                fieldValue = ex;
            }
        }
        return fieldValue;
    }
}

