/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.util.Collection;
import java.util.Map;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.result.ArrayComparator;
import org.openl.rules.testmethod.result.CollectionComparator;
import org.openl.rules.testmethod.result.ComparableComparator;
import org.openl.rules.testmethod.result.GenericComparator;
import org.openl.rules.testmethod.result.MapComparator;
import org.openl.rules.testmethod.result.NumberComparator;
import org.openl.rules.testmethod.result.ObjectComparator;
import org.openl.rules.testmethod.result.StringComparator;
import org.openl.rules.testmethod.result.TestResultComparator;

public class TestResultComparatorFactory {
    private static final StringComparator STRING = new StringComparator();
    private static final NumberComparator NUMBER = new NumberComparator();
    private static final ComparableComparator COMPARABLE = new ComparableComparator();
    private static final CollectionComparator COLLECTION = new CollectionComparator();
    private static final MapComparator MAP = new MapComparator();
    private static final ObjectComparator OBJECT = new ObjectComparator();
    private static final GenericComparator GENERIC = new GenericComparator();

    private TestResultComparatorFactory() {
    }

    public static TestResultComparator getComparator(Class<?> clazz, Double delta) {
        if (clazz.isArray()) {
            return new ArrayComparator(clazz.getComponentType(), delta);
        }
        if (String.class.equals(clazz)) {
            return STRING;
        }
        if (NumberUtils.isFloatPointType(clazz)) {
            if (delta == null) {
                return NUMBER;
            }
            return new NumberComparator(delta);
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return COLLECTION;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MAP;
        }
        if (Object.class.equals(clazz)) {
            if (delta == null) {
                return OBJECT;
            }
            return new ObjectComparator(delta);
        }
        return GENERIC;
    }
}

