/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.binding.MethodUtil;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContextMutableUUID;
import org.openl.rules.lang.xls.binding.TableVersionComparator;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.rules.lang.xls.prebind.LazyMethodWrapper;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.method.TableUriMethod;
import org.openl.rules.table.properties.DimensionPropertiesMethodKey;
import org.openl.rules.types.ValidationMessages;
import org.openl.runtime.IRuntimeContext;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.impl.MethodKey;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public abstract class OpenMethodDispatcher
implements IOpenMethod {
    private IOpenMethod delegate;
    private MethodKey delegateKey;
    private List<IOpenMethod> candidates = new ArrayList<IOpenMethod>();
    private final Invokable invokeInner = new Invokable(){

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return OpenMethodDispatcher.this.invokeInner(target, params, env);
        }
    };
    private Map<UUID, IOpenMethod> cache = new LinkedHashMap<UUID, IOpenMethod>();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final int MAX_ELEMENTS_IN_CAHCE = 1000;
    private Set<MethodKey> candidateKeys = new HashSet<MethodKey>();

    protected void decorate(IOpenMethod delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        this.delegate = delegate;
        this.delegateKey = new MethodKey(delegate);
        this.candidates.add(delegate);
    }

    public IMethodSignature getSignature() {
        return this.delegate.getSignature();
    }

    public IOpenClass getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenClass getType() {
        return this.delegate.getType();
    }

    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    public boolean isConstructor() {
        return false;
    }

    public String getDisplayName(int mode) {
        return this.delegate.getDisplayName(mode);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public List<IOpenMethod> getCandidates() {
        return this.candidates;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return Tracer.invoke((Invokable)this.invokeInner, (Object)target, (Object[])params, (IRuntimeEnv)env, (Object)this);
    }

    public IOpenMethod findMatchingMethod(IRuntimeEnv env) {
        IRuntimeContext context = env.getContext();
        IOpenMethod method = null;
        if (context instanceof IRulesRuntimeContextMutableUUID) {
            IRulesRuntimeContextMutableUUID contextMutableUUID = (IRulesRuntimeContextMutableUUID)context;
            method = this.findInCache(contextMutableUUID);
            if (method == null) {
                method = this.findMatchingMethod(this.candidates, context);
                this.putToCache(contextMutableUUID, method);
            }
        } else {
            method = this.findMatchingMethod(this.candidates, context);
        }
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Method signature: ");
            MethodUtil.printMethod((IOpenMethodHeader)this, (StringBuilder)sb);
            sb.append("\n");
            sb.append("Context: ");
            sb.append(context.toString());
            String message = String.format("Appropriate overloaded method for '%1$s' is not found. Details: \n%2$s", this.getName(), sb.toString());
            throw new OpenLRuntimeException(message);
        }
        while (method instanceof LazyMethodWrapper || method instanceof MethodDelegator) {
            if (method instanceof LazyMethodWrapper) {
                method = ((LazyMethodWrapper)method).getCompiledMethod(env);
            }
            if (!(method instanceof MethodDelegator)) continue;
            MethodDelegator methodDelegator = (MethodDelegator)method;
            method = methodDelegator.getMethod();
        }
        if (method instanceof IOpenMethodWrapper) {
            method = ((IOpenMethodWrapper)method).getDelegate();
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToCache(IRulesRuntimeContextMutableUUID contextMutableUUID, IOpenMethod method) {
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            this.cache.put(contextMutableUUID.contextUUID(), method);
            if (this.cache.size() > 1000) {
                Iterator<UUID> itr = this.cache.keySet().iterator();
                itr.next();
                itr.remove();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOpenMethod findInCache(IRulesRuntimeContextMutableUUID contextMutableUUID) {
        IOpenMethod method;
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            method = this.cache.get(contextMutableUUID.contextUUID());
        }
        finally {
            readLock.unlock();
        }
        return method;
    }

    protected Object invokeInner(Object target, Object[] params, IRuntimeEnv env) {
        IOpenMethod method = this.findMatchingMethod(env);
        Tracer.put((Object)this, (String)"rule", (Object[])new Object[]{method});
        return method.invoke(target, params, env);
    }

    protected IOpenMethod useActiveOrNewerVersion(IOpenMethod existedMethod, IOpenMethod newMethod, MethodKey key) throws DuplicatedMethodException {
        int compareResult = TableVersionComparator.getInstance().compare(existedMethod, newMethod);
        if (compareResult > 0) {
            return newMethod;
        }
        if (compareResult == 0) {
            if (newMethod instanceof TableUriMethod && existedMethod instanceof TableUriMethod) {
                String existedMethodHashUrl;
                String newMethodHashUrl = ((TableUriMethod)newMethod).getTableUri();
                if (!newMethodHashUrl.equals(existedMethodHashUrl = ((TableUriMethod)existedMethod).getTableUri())) {
                    String message = ValidationMessages.getDuplicatedMethodMessage(existedMethod, newMethod);
                    throw new DuplicatedMethodException(message, existedMethod);
                }
            } else {
                throw new IllegalStateException("Implementation supports only TableUriMethod!");
            }
        }
        return existedMethod;
    }

    private int searchTheSameMethod(IOpenMethod candidate) {
        int i = 0;
        for (IOpenMethod existedMethod : this.candidates) {
            DimensionPropertiesMethodKey existedMethodPropertiesKey;
            DimensionPropertiesMethodKey newMethodPropertiesKey;
            if (existedMethod instanceof ITablePropertiesMethod && candidate instanceof ITablePropertiesMethod && (newMethodPropertiesKey = new DimensionPropertiesMethodKey(candidate)).equals(existedMethodPropertiesKey = new DimensionPropertiesMethodKey(existedMethod))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addMethod(IOpenMethod candidate) {
        MethodKey candidateKey = new MethodKey(candidate);
        if (this.delegateKey.equals((Object)candidateKey)) {
            int i = this.searchTheSameMethod(candidate);
            if (i < 0) {
                this.candidates.add(candidate);
            } else {
                IOpenMethod existedMethod = this.candidates.get(i);
                try {
                    candidate = this.useActiveOrNewerVersion(existedMethod, candidate, candidateKey);
                    this.candidates.set(i, candidate);
                }
                catch (DuplicatedMethodException e) {
                    if (!this.candidateKeys.contains(candidateKey)) {
                        IMemberMetaInfo memberMetaInfo;
                        if (existedMethod instanceof IMemberMetaInfo && (memberMetaInfo = (IMemberMetaInfo)existedMethod).getSyntaxNode() != null && memberMetaInfo.getSyntaxNode() instanceof TableSyntaxNode) {
                            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, (ISyntaxNode)memberMetaInfo.getSyntaxNode());
                            ((TableSyntaxNode)memberMetaInfo.getSyntaxNode()).addError(error);
                        }
                        this.candidateKeys.add(candidateKey);
                    }
                    throw e;
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            MethodUtil.printMethod((IOpenMethodHeader)this, (StringBuilder)sb);
            throw new OpenLRuntimeException("Invalid method signature to overload: " + sb.toString());
        }
    }

    protected abstract IOpenMethod findMatchingMethod(List<IOpenMethod> var1, IRuntimeContext var2);

    public IOpenMethod getTargetMethod() {
        return this.delegate;
    }

    public abstract TableSyntaxNode getDispatcherTable();
}

