/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.DefaultPropertiesContextMatcher;
import org.openl.rules.types.impl.DefaultPropertiesIntersectionFinder;
import org.openl.rules.types.impl.DefaultTablePropertiesSorter;
import org.openl.rules.types.impl.IPropertiesContextMatcher;
import org.openl.rules.types.impl.MatchingResult;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class MatchingOpenMethodDispatcher
extends OpenMethodDispatcher {
    private static final IPropertiesContextMatcher matcher = new DefaultPropertiesContextMatcher();
    private static final DefaultTablePropertiesSorter prioritySorter = new DefaultTablePropertiesSorter();
    private static final DefaultPropertiesIntersectionFinder intersectionMatcher = new DefaultPropertiesIntersectionFinder();
    private XlsModuleOpenClass moduleOpenClass;
    private List<IOpenMethod> candidatesSorted;
    private IOpenMethod decisionTableOpenMethod;

    public IOpenMethod getDecisionTableOpenMethod() {
        return this.decisionTableOpenMethod;
    }

    public void setDecisionTableOpenMethod(IOpenMethod decisionTableOpenMethod) {
        this.decisionTableOpenMethod = decisionTableOpenMethod;
    }

    public MatchingOpenMethodDispatcher() {
    }

    public MatchingOpenMethodDispatcher(IOpenMethod method, XlsModuleOpenClass moduleOpenClass) {
        this.decorate(method);
        this.moduleOpenClass = moduleOpenClass;
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return this.moduleOpenClass;
    }

    @Override
    public void addMethod(IOpenMethod candidate) {
        super.addMethod(candidate);
        this.candidatesSorted = null;
    }

    @Override
    protected IOpenMethod findMatchingMethod(List<IOpenMethod> candidates, IRuntimeContext context) {
        HashSet<IOpenMethod> selected = new HashSet<IOpenMethod>(candidates);
        this.selectCandidates(selected, (IRulesRuntimeContext)context);
        this.maxMinSelectCandidates(selected, (IRulesRuntimeContext)context);
        switch (selected.size()) {
            case 0: {
                IOpenMethod candidateMethod = candidates.iterator().next();
                throw new OpenLRuntimeException(String.format("No matching methods with name '%3$s' for the context. Details: \n%1$s\nContext: %2$s", this.toString(candidates), context.toString(), candidateMethod.getName()));
            }
            case 1: {
                IOpenMethod matchingMethod = (IOpenMethod)selected.iterator().next();
                return matchingMethod;
            }
        }
        IOpenMethod method = (IOpenMethod)selected.iterator().next();
        throw new OpenLRuntimeException(String.format("Ambiguous dispatch for method '%3$s'. Details: \n%1$s\nContext: %2$s", this.toString(selected), context.toString(), method.getName()));
    }

    @Override
    public TableSyntaxNode getDispatcherTable() {
        if (this.decisionTableOpenMethod == null) {
            DispatcherTablesBuilder dispTableBuilder = new DispatcherTablesBuilder(this.moduleOpenClass, this.moduleOpenClass.getRulesModuleBindingContext());
            dispTableBuilder.build(this);
        }
        if (this.decisionTableOpenMethod != null) {
            return (TableSyntaxNode)this.decisionTableOpenMethod.getInfo().getSyntaxNode();
        }
        throw new IllegalStateException(String.format("There is no dispatcher table for [%s] method.", this.getName()));
    }

    @Override
    public IMemberMetaInfo getInfo() {
        if (this.getCandidates().size() == 1) {
            return this.getCandidates().get(0).getInfo();
        }
        return this.getDispatcherTable().getMember().getInfo();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void maxMinSelectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        if (selected.size() > 1) {
            ArrayList notPriorMethods = new ArrayList();
            List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
            ArrayList<IOpenMethod> mostPriority = new ArrayList<IOpenMethod>();
            ITableProperties mostPriorityProperties = null;
            for (IOpenMethod candidate : selected) {
                if (mostPriority.isEmpty()) {
                    mostPriority.add(candidate);
                    mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                    continue;
                }
                ITableProperties candidateProperties = PropertiesHelper.getTableProperties(candidate);
                int cmp = this.compareMaxMinPriorities(candidateProperties, mostPriorityProperties);
                if (cmp < 0) {
                    notPriorMethods.addAll(mostPriority);
                    mostPriority.clear();
                    mostPriority.add(candidate);
                    mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                }
                if (cmp == 0) {
                    mostPriority.add(candidate);
                }
                if (cmp <= 0) continue;
                notPriorMethods.add(candidate);
            }
            selected.removeAll(notPriorMethods);
            if (selected.size() > 1) {
                notPriorMethods.clear();
                mostPriority.clear();
                block13: for (IOpenMethod candidate : selected) {
                    boolean nested = false;
                    boolean contains = false;
                    if (mostPriority.isEmpty()) {
                        mostPriority.add(candidate);
                        mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                        continue;
                    }
                    ITableProperties candidateProperties = PropertiesHelper.getTableProperties(candidate);
                    if (mostPriority.size() == 1) {
                        block14: for (String propName : notNullPropertyNames) {
                            switch (intersectionMatcher.match(propName, candidateProperties, mostPriorityProperties)) {
                                case NESTED: {
                                    nested = true;
                                    break;
                                }
                                case CONTAINS: {
                                    contains = true;
                                    break;
                                }
                                case EQUALS: {
                                    break;
                                }
                                case NO_INTERSECTION: 
                                case PARTLY_INTERSECTS: {
                                    nested = false;
                                    contains = false;
                                    break block14;
                                }
                            }
                        }
                        if (nested && !contains && mostPriority.size() == 1) {
                            notPriorMethods.addAll(mostPriority);
                            mostPriority.clear();
                            mostPriority.add(candidate);
                            mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                            continue;
                        }
                        if (contains && !nested && mostPriority.size() == 1) {
                            notPriorMethods.add(candidate);
                            continue;
                        }
                        mostPriority.add(candidate);
                        continue;
                    }
                    boolean moreConcreteMethod = true;
                    Iterator iterator = mostPriority.iterator();
                    block15: while (true) {
                        if (!iterator.hasNext()) {
                            if (moreConcreteMethod) {
                                notPriorMethods.addAll(mostPriority);
                                mostPriority.clear();
                                mostPriority.add(candidate);
                                mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                                continue block13;
                            }
                            mostPriority.add(candidate);
                            continue block13;
                        }
                        IOpenMethod m = (IOpenMethod)iterator.next();
                        ITableProperties mProperties = PropertiesHelper.getTableProperties(m);
                        Iterator<String> iterator2 = notNullPropertyNames.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block15;
                            String propName = iterator2.next();
                            switch (intersectionMatcher.match(propName, candidateProperties, mProperties)) {
                                case NESTED: {
                                    break;
                                }
                                case CONTAINS: {
                                    moreConcreteMethod = false;
                                    continue block15;
                                }
                                case EQUALS: {
                                    break;
                                }
                                case NO_INTERSECTION: 
                                case PARTLY_INTERSECTS: {
                                    moreConcreteMethod = false;
                                    continue block15;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            selected.removeAll(notPriorMethods);
        }
    }

    private int compareMaxMinPriorities(ITableProperties properties1, ITableProperties properties2) {
        for (Comparator<ITableProperties> comparator : prioritySorter.getMaxMinPriorityRules()) {
            int cmp = comparator.compare(properties1, properties2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private void selectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        ArrayList<IOpenMethod> nomatched = new ArrayList<IOpenMethod>();
        List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
        block3: for (IOpenMethod method : selected) {
            ITableProperties props = PropertiesHelper.getTableProperties(method);
            for (String propName : notNullPropertyNames) {
                MatchingResult res = matcher.match(propName, props, context);
                switch (res) {
                    case NO_MATCH: {
                        nomatched.add(method);
                        continue block3;
                    }
                }
            }
        }
        selected.removeAll(nomatched);
    }

    private String toString(Collection<IOpenMethod> methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("Candidates: {\n");
        boolean g = false;
        for (IOpenMethod method : methods) {
            if (g) {
                builder.append(",\n");
            } else {
                g = true;
            }
            builder.append("{");
            ITableProperties tableProperties = PropertiesHelper.getTableProperties(method);
            boolean f = false;
            for (Map.Entry<String, Object> entry : tableProperties.getAllDimensionalProperties().entrySet()) {
                if (f) {
                    builder.append(", ");
                } else {
                    f = true;
                }
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(tableProperties.getPropertyValueAsString(entry.getKey()));
            }
            builder.append("}");
        }
        builder.append("\n}\n");
        return builder.toString();
    }

    @Override
    public List<IOpenMethod> getCandidates() {
        if (this.candidatesSorted == null) {
            this.candidatesSorted = prioritySorter.sort(super.getCandidates());
        }
        return this.candidatesSorted;
    }

    @Override
    public IOpenClass getType() {
        IOpenClass type = this.getDeclaringClass().findType(super.getType().getName());
        if (type == null) {
            return super.getType();
        }
        return type;
    }

    private List<String> getNotNullPropertyNames(IRulesRuntimeContext context) {
        ArrayList<String> propNames = new ArrayList<String>();
        if (context.getCurrentDate() != null) {
            propNames.add("effectiveDate");
        }
        if (context.getCurrentDate() != null) {
            propNames.add("expirationDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("startRequestDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("endRequestDate");
        }
        if (context.getCaRegion() != null) {
            propNames.add("caRegions");
        }
        if (context.getCaProvince() != null) {
            propNames.add("caProvinces");
        }
        if (context.getCountry() != null) {
            propNames.add("country");
        }
        if (context.getRegion() != null) {
            propNames.add("region");
        }
        if (context.getCurrency() != null) {
            propNames.add("currency");
        }
        if (context.getLang() != null) {
            propNames.add("lang");
        }
        if (context.getLob() != null) {
            propNames.add("lob");
        }
        if (context.getUsRegion() != null) {
            propNames.add("usregion");
        }
        if (context.getUsState() != null) {
            propNames.add("state");
        }
        if (context.getNature() != null) {
            propNames.add("nature");
        }
        return propNames;
    }
}

