/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IDecisionTable;
import org.openl.rules.dt.type.domains.DomainAdaptorFactory;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableValidationResult;
import org.openl.rules.dt.validator.DecisionTableValidator;
import org.openl.rules.enumeration.ValidateDTEnum;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.validation.OpenMethodDispatcherHelper;
import org.openl.rules.validation.TablesValidator;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;

public class GapOverlapValidator
extends TablesValidator {
    private static final String VALIDATION_FAILED = "Validation failed for node : ";
    private ValidationResult validationResult;

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        this.validationResult = null;
        List<IOpenMethod> allModuleMethods = OpenMethodDispatcherHelper.extractMethods(openClass);
        for (IOpenMethod method : allModuleMethods) {
            IDecisionTable decisionTable;
            DecisionTableValidationResult dtValidResult;
            ExecutableRulesMethod executableMethod;
            if (!(method instanceof ExecutableRulesMethod) || !GapOverlapValidator.isValidatableMethod(executableMethod = (ExecutableRulesMethod)method) || (dtValidResult = this.validate(openClass, decisionTable = (IDecisionTable)((Object)executableMethod))) == null || !dtValidResult.hasProblems()) continue;
            decisionTable.getSyntaxNode().setValidationResult(dtValidResult);
            if (dtValidResult.hasErrors()) {
                this.addError(decisionTable.getSyntaxNode(), dtValidResult.toString());
                continue;
            }
            this.addWarning(decisionTable.getSyntaxNode(), dtValidResult.toString());
        }
        if (this.validationResult != null) {
            return this.validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private DecisionTableValidationResult validate(IOpenClass openClass, IDecisionTable decisionTable) {
        DecisionTableValidationResult dtValidResult = null;
        try {
            Map<String, IDomainAdaptor> domains = this.gatherDomains(decisionTable);
            dtValidResult = DecisionTableValidator.validateTable(decisionTable, domains, openClass);
        }
        catch (Exception t) {
            String errorMessage = String.format("%s%s.Reason : %s", VALIDATION_FAILED, decisionTable.getSyntaxNode().getDisplayName(), t.getMessage());
            this.addError(decisionTable.getSyntaxNode(), errorMessage);
        }
        return dtValidResult;
    }

    private Map<String, IDomainAdaptor> gatherDomains(IDecisionTable dt) throws Exception {
        HashMap<String, IDomainAdaptor> domainsMap = new HashMap<String, IDomainAdaptor>();
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(dt);
        for (IBaseCondition condition : dt.getConditionRows()) {
            IParameterDeclaration[] pd = analyzer.referencedSignatureParams(condition);
            for (int i = 0; i < pd.length; ++i) {
                IDomain<?> domain = pd[i].getType().getDomain();
                if (domain != null) continue;
                domain = condition.getConditionEvaluator().getRuleParameterDomain(condition);
                IDomainAdaptor adaptor = DomainAdaptorFactory.getAdaptor(domain);
                domainsMap.put(pd[i].getName(), adaptor);
            }
            IParameterDeclaration[] cparams = condition.getParams();
            for (int i = 0; i < cparams.length; ++i) {
                IDomain<?> domain = cparams[i].getType().getDomain();
                if (domain != null || (domain = condition.getConditionEvaluator().getConditionParameterDomain(i, condition)) == null) continue;
                IDomainAdaptor adaptor = DomainAdaptorFactory.getAdaptor(domain);
                domainsMap.put(DecisionTableValidator.getUniqueConditionParamName(condition, cparams[i].getName()), adaptor);
            }
        }
        return domainsMap;
    }

    private void addError(TableSyntaxNode sourceNode, String message) {
        if (this.validationResult == null) {
            this.validationResult = new ValidationResult(ValidationStatus.FAIL);
        }
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)sourceNode);
        sourceNode.addError(error);
        ValidationUtils.addValidationMessage(this.validationResult, (OpenLMessage)new OpenLErrorMessage((OpenLException)error));
    }

    private void addWarning(TableSyntaxNode sourceNode, String message) {
        if (this.validationResult == null) {
            this.validationResult = new ValidationResult(ValidationStatus.FAIL);
        }
        ValidationUtils.addValidationMessage(this.validationResult, (OpenLMessage)new OpenLWarnMessage(message, (ISyntaxNode)sourceNode));
    }

    private static boolean isValidatableMethod(ExecutableRulesMethod executableMethod) {
        return executableMethod.getMethodProperties() != null && ValidateDTEnum.ON.equals((Object)executableMethod.getMethodProperties().getValidateDT());
    }
}

