/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADispatcherTableColumn;
import org.openl.rules.validation.properties.dimentional.DispatcherTableRules;

public class ArrayParameterColumn
extends ADispatcherTableColumn {
    public ArrayParameterColumn(TablePropertyDefinition arrayDimensionProperty, DispatcherTableRules rules) {
        super(arrayDimensionProperty, rules);
        this.validate();
    }

    private void validate() {
        if (!this.getProperty().getType().getInstanceClass().isArray()) {
            throw new OpenlNotCheckedException("Can`t create array parameter column for not an array property");
        }
    }

    @Override
    public String getCodeExpression() {
        MatchingExpression matchExpression = this.getProperty().getExpression();
        String result = ArrayParameterColumn.getMatchByDefaultCodeExpression(matchExpression);
        StringBuilder codeExpression = new StringBuilder();
        if (matchExpression != null) {
            codeExpression.append("contains(");
            codeExpression.append(this.getLocalParameterName());
            codeExpression.append(",");
            codeExpression.append(matchExpression.getMatchExpression().getContextAttribute());
            codeExpression.append(")");
            result = result + codeExpression.toString();
        } else {
            String message = String.format("Can`t create expression for \"%s\" property validation.", this.getProperty().getName());
            OpenLMessagesUtils.addWarn((String)message);
        }
        return result;
    }

    @Override
    public String getTitle() {
        return this.getProperty().getDisplayName();
    }

    @Override
    public String getParameterDeclaration() {
        Class<?> componentType = this.getProperty().getType().getInstanceClass().getComponentType();
        String simpleName = componentType.getSimpleName() + "[]";
        String localParameterName = this.getLocalParameterName();
        return new StringBuilder(64).append(simpleName).append(' ').append(localParameterName).toString();
    }

    @Override
    public String getRuleValue(int ruleIndex, int localParameterIndex) {
        return this.getRules().getRule(ruleIndex).getPropertyValueAsString(this.getProperty().getName());
    }

    private String getLocalParameterName() {
        return (this.getProperty().getName() + "Local").intern();
    }
}

