/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.validation.properties.dimentional.IDecisionTableReturnColumn;
import org.openl.rules.validation.properties.dimentional.TableSyntaxNodeDispatcherBuilder;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;

public class DispatcherTableReturnColumn
implements IDecisionTableReturnColumn {
    private IOpenClass originalReturnType;
    private String methodName;
    private IMethodSignature originalSignature;
    private static final String RESULT_VAR = "result";

    protected DispatcherTableReturnColumn(IOpenClass originalReturnType, String methodName, IMethodSignature originalSignature) {
        this.originalReturnType = originalReturnType;
        this.methodName = methodName;
        this.originalSignature = originalSignature;
    }

    public DispatcherTableReturnColumn(MatchingOpenMethodDispatcher dispatcher) {
        this(dispatcher.getType(), dispatcher.getName(), dispatcher.getSignature());
    }

    @Override
    public String getParameterDeclaration() {
        return String.format("%s %s", this.getReturnType().getDisplayName(0), this.getCodeExpression());
    }

    @Override
    public String getCodeExpression() {
        return RESULT_VAR;
    }

    @Override
    public String getTitle() {
        return this.getCodeExpression().toUpperCase();
    }

    @Override
    public String getRuleValue(int ruleIndex, int elementNum) {
        StringBuilder builder = new StringBuilder(128);
        builder.append('=').append(this.methodName).append("$").append(ruleIndex).append('(');
        boolean prependComma = false;
        int numberOfParameters = this.originalSignature.getNumberOfParameters();
        for (int i = 0; i < numberOfParameters; ++i) {
            String parameterName = this.originalSignature.getParameterName(i);
            String parameter = TableSyntaxNodeDispatcherBuilder.getDispatcherParameterNameForOriginalParameter(parameterName);
            if (prependComma) {
                builder.append(',');
            }
            builder.append(parameter);
            prependComma = true;
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public IOpenClass getReturnType() {
        return this.originalReturnType;
    }

    public IMethodSignature getOriginalSignature() {
        return this.originalSignature;
    }

    @Override
    public int getNumberOfLocalParameters() {
        return 1;
    }

    @Override
    public String getRuleValue(int ruleIndex) {
        return this.getRuleValue(ruleIndex, 0);
    }

    @Override
    public String getColumnType() {
        return DecisionTableColumnHeaders.RETURN.getHeaderKey();
    }
}

