/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADispatcherTableColumn;
import org.openl.rules.validation.properties.dimentional.DispatcherTableRules;

public class SimpleParameterColumn
extends ADispatcherTableColumn {
    public SimpleParameterColumn(TablePropertyDefinition property, DispatcherTableRules rules) {
        super(property, rules);
    }

    @Override
    public String getCodeExpression() {
        String result = "";
        String propertyName = this.getProperty().getName();
        MatchingExpression matchExpression = this.getProperty().getExpression();
        if (matchExpression != null) {
            String parameterName = propertyName + "Local";
            result = SimpleParameterColumn.getMatchByDefaultCodeExpression(matchExpression) + matchExpression.getMatchExpression().getCodeExpression(parameterName);
        } else {
            String message = String.format("Can`t create expression for \"%s\" property validation.", propertyName);
            OpenLMessagesUtils.addWarn((String)message);
        }
        return result;
    }

    @Override
    public String getTitle() {
        return this.getProperty().getDisplayName();
    }

    @Override
    public String getParameterDeclaration() {
        String propertyTypeName = this.getProperty().getType().getInstanceClass().getSimpleName();
        return String.format("%s %s%s", propertyTypeName, this.getProperty().getName(), "Local");
    }

    @Override
    public String getRuleValue(int ruleIndex, int elementNum) {
        return this.getRules().getRule(ruleIndex).getPropertyValueAsString(this.getProperty().getName());
    }
}

