/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.MultiCallMethodBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayArgumentsMethodBinder
extends ANodeBinder {
    private final Logger log = LoggerFactory.getLogger(ArrayArgumentsMethodBinder.class);
    private String methodName;
    private IOpenClass[] argumentsTypes;
    private IBoundNode[] children;

    public ArrayArgumentsMethodBinder(String methodName, IOpenClass[] argumentsTypes, IBoundNode[] children) {
        this.methodName = methodName;
        this.argumentsTypes = (IOpenClass[])argumentsTypes.clone();
        this.children = (IBoundNode[])children.clone();
    }

    private IBoundNode getMultiCallMethodNode(ISyntaxNode node, IBindingContext bindingContext, IOpenClass[] methodArguments, Deque<Integer> arrayArgArguments) {
        IMethodCaller singleParameterMethodCaller = bindingContext.findMethodCaller("org.openl.this", this.methodName, methodArguments);
        if (singleParameterMethodCaller == null) {
            return null;
        }
        BindHelper.checkOnDeprecation((ISyntaxNode)node, (IBindingContext)bindingContext, (IMethodCaller)singleParameterMethodCaller);
        return this.makeMultiCallMethodBoundNode(node, this.children, new ArrayList<Integer>(arrayArgArguments), singleParameterMethodCaller);
    }

    protected IBoundNode makeMultiCallMethodBoundNode(ISyntaxNode node, IBoundNode[] children, List<Integer> arrayArgArgumentList, IMethodCaller singleParameterMethodCaller) {
        return new MultiCallMethodBoundNode(node, children, singleParameterMethodCaller, arrayArgArgumentList);
    }

    private IBoundNode getMultiCallMethodNode(ISyntaxNode node, IBindingContext bindingContext, IOpenClass[] unwrappedArgumentsTypes, Deque<Integer> arrayArgArguments, List<Integer> indexesOfArrayArguments, int indexToChange) {
        IBoundNode multiCallMethodNode;
        int arrayArgumentIndex = indexesOfArrayArguments.get(indexToChange);
        boolean last = indexToChange == indexesOfArrayArguments.size() - 1;
        unwrappedArgumentsTypes[arrayArgumentIndex] = this.argumentsTypes[arrayArgumentIndex];
        IBoundNode iBoundNode = multiCallMethodNode = last ? this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgArguments) : this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgArguments, indexesOfArrayArguments, indexToChange + 1);
        if (multiCallMethodNode != null) {
            return multiCallMethodNode;
        }
        arrayArgArguments.addLast(arrayArgumentIndex);
        unwrappedArgumentsTypes[arrayArgumentIndex] = this.argumentsTypes[arrayArgumentIndex].getComponentClass();
        multiCallMethodNode = last ? this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgArguments) : this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgArguments, indexesOfArrayArguments, indexToChange + 1);
        arrayArgArguments.removeLast();
        if (multiCallMethodNode != null) {
            return multiCallMethodNode;
        }
        return null;
    }

    private List<Integer> getIndexesOfArrayArguments() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.argumentsTypes.length; ++i) {
            if (!this.argumentsTypes[i].isArray()) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        List<Integer> indexesOfArrayArguments = this.getIndexesOfArrayArguments();
        if (indexesOfArrayArguments.size() > 0) {
            IOpenClass[] unwrappedArgumentsTypes = new IOpenClass[this.argumentsTypes.length];
            System.arraycopy(this.argumentsTypes, 0, unwrappedArgumentsTypes, 0, this.argumentsTypes.length);
            ArrayDeque<Integer> arrayArgArguments = new ArrayDeque<Integer>();
            return this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgArguments, indexesOfArrayArguments, 0);
        }
        this.log.debug("There is no any array argument in signature for {} method", (Object)this.methodName);
        return null;
    }
}

