/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ABoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class ArrayBoundNode
extends ABoundNode {
    int dimensions;
    IOpenClass arrayType;
    IOpenClass componentType;

    public ArrayBoundNode(ISyntaxNode syntaxNode, IBoundNode[] children, int dimensions, IOpenClass arrayType, IOpenClass componentType) {
        super(syntaxNode, children);
        this.dimensions = dimensions;
        this.arrayType = arrayType;
        this.componentType = componentType;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        Object[] res = this.evaluateChildren(env);
        int[] dims = new int[this.dimensions + res.length];
        for (int i = 0; i < res.length; ++i) {
            dims[i] = (Integer)res[i];
        }
        return this.componentType.getAggregateInfo().makeIndexedAggregate(this.componentType, dims);
    }

    public IOpenClass getType() {
        return this.arrayType;
    }

    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addTypeDependency(this.componentType, (IBoundNode)this);
    }
}

