/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class ArrayInitializerNode
extends ABoundNode {
    IOpenClass type;
    IOpenCast[] casts;

    public ArrayInitializerNode(ISyntaxNode syntaxNode, IBoundNode[] children, IOpenClass type, IOpenCast[] casts) {
        super(syntaxNode, children);
        this.type = type;
        this.casts = casts;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        IAggregateInfo info = this.type.getAggregateInfo();
        Object ary = info.makeIndexedAggregate(info.getComponentType(this.type), new int[]{this.children.length});
        IOpenIndex index = info.getIndex(this.type, (IOpenClass)JavaOpenClass.INT);
        for (int i = 0; i < this.children.length; ++i) {
            Object obj = this.children[i].evaluate(env);
            if (this.casts[i] != null) {
                obj = this.casts[i].convert(obj);
            }
            index.setValue(ary, (Object)i, obj);
        }
        return ary;
    }

    public IOpenClass getType() {
        return this.type;
    }
}

