/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.AssignNode;
import org.openl.binding.impl.BinaryOperatorNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

public class AssignOperatorNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        if (node.getNumberOfChildren() != 2) {
            BindHelper.processError((String)"Assign node must have 2 subnodes", (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        int index = node.getType().lastIndexOf(46);
        String methodName = node.getType().substring(index + 1);
        IBoundNode[] children = AssignOperatorNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        if (!children[0].isLvalue()) {
            String message = String.format("The node '%s' is not an Lvalue", children[0].getClass().getName());
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        IOpenClass[] types = AssignOperatorNodeBinder.getTypes((IBoundNode[])children);
        IOpenClass leftType = types[0];
        IMethodCaller methodCaller = null;
        if (!"assign".equals(methodName) && (methodCaller = BinaryOperatorNodeBinder.findBinaryOperatorMethodCaller((String)methodName, (IOpenClass[])types, (IBindingContext)bindingContext)) == null) {
            String message = BinaryOperatorNodeBinder.errorMsg((String)methodName, (IOpenClass)types[0], (IOpenClass)types[1]);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        IOpenClass rightType = methodCaller == null ? types[1] : methodCaller.getMethod().getType();
        IOpenCast cast = null;
        if (!(rightType.equals(leftType) || (cast = bindingContext.getCast(rightType, leftType)) != null && (cast.isImplicit() || children[1] instanceof LiteralBoundNode))) {
            if (!NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{rightType, leftType})) {
                String message = String.format("Can not convert from '%s' to '%s'", rightType.getName(), leftType.getName());
                BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            }
            return new ErrorBoundNode(node);
        }
        return new AssignNode(node, children, methodCaller, cast);
    }
}

