/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BusinessNumberNodeBinder;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class BusinessIntNodeBinder
extends BusinessNumberNodeBinder {
    private int getIntValue(Long number, ISyntaxNode node) throws SyntaxNodeException {
        if (number > Integer.MAX_VALUE || number < Integer.MIN_VALUE) {
            String message = String.format("Number %d is outside the valid range %d - %d", (long)number, Integer.MIN_VALUE, Integer.MAX_VALUE);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)node);
        }
        return number.intValue();
    }

    @Override
    protected IBoundNode makeNumber(String literal, int multiplier, ISyntaxNode node) throws SyntaxNodeException {
        Long parsedNumber;
        int FRACTION_DELIMITER = 46;
        if (literal.indexOf(46) >= 0) {
            Double x = Double.parseDouble(literal) * (double)multiplier;
            parsedNumber = Math.round(x);
        } else {
            parsedNumber = Long.parseLong(literal) * (long)multiplier;
        }
        int number = this.getIntValue(parsedNumber, node);
        return new LiteralBoundNode(node, (Object)number, (IOpenClass)JavaOpenClass.INT);
    }
}

