/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.util.OpenClassUtils;

public final class CastToWiderType {
    private final IOpenClass widerType;
    private final IOpenCast cast1;
    private final IOpenCast cast2;

    private CastToWiderType(IOpenClass widerType, IOpenCast cast1, IOpenCast cast2) {
        this.widerType = widerType;
        this.cast1 = cast1;
        this.cast2 = cast2;
    }

    public IOpenClass getWiderType() {
        return this.widerType;
    }

    public IOpenCast getCast1() {
        return this.cast1;
    }

    public IOpenCast getCast2() {
        return this.cast2;
    }

    public static CastToWiderType create(IBindingContext bindingContext, IOpenClass type1, IOpenClass type2) {
        if (NullOpenClass.the.equals(type1)) {
            return new CastToWiderType(type2, null, null);
        }
        IOpenCast cast1To2 = bindingContext.getCast(type1, type2);
        IOpenCast cast2To1 = bindingContext.getCast(type2, type1);
        if (cast1To2 == null && cast2To1 == null) {
            IOpenClass parentClass = OpenClassUtils.findParentClassWithBoxing((IOpenClass)type1, (IOpenClass)type2);
            if (parentClass != null) {
                IOpenCast castToParent1 = bindingContext.getCast(type1, parentClass);
                IOpenCast castToParent2 = bindingContext.getCast(type2, parentClass);
                return new CastToWiderType(parentClass, castToParent1, castToParent2);
            }
        } else {
            if ((cast1To2 == null || !cast1To2.isImplicit()) && cast2To1 != null && cast2To1.isImplicit()) {
                return new CastToWiderType(type1, null, cast2To1);
            }
            if ((cast2To1 == null || !cast2To1.isImplicit()) && cast1To2 != null && cast1To2.isImplicit()) {
                return new CastToWiderType(type2, cast1To2, null);
            }
            if (cast1To2 != null && cast2To1 != null && cast1To2.isImplicit() && cast2To1.isImplicit()) {
                if (cast1To2.getDistance(type1, type2) < cast2To1.getDistance(type2, type1)) {
                    return new CastToWiderType(type2, cast1To2, null);
                }
                return new CastToWiderType(type1, null, cast2To1);
            }
        }
        return new CastToWiderType(type1, null, null);
    }
}

