/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ABoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class IfNode
extends ABoundNode {
    private final IBoundNode conditionNode;
    private final IBoundNode elseNode;
    private final IBoundNode thenNode;
    private final IOpenClass type;

    IfNode(ISyntaxNode syntaxNode, IBoundNode conditionNode, IBoundNode thenNode, IOpenClass type) {
        super(syntaxNode, new IBoundNode[]{conditionNode, thenNode});
        this.conditionNode = conditionNode;
        this.thenNode = thenNode;
        this.elseNode = null;
        this.type = type;
    }

    IfNode(ISyntaxNode syntaxNode, IBoundNode conditionNode, IBoundNode thenNode, IBoundNode elseNode, IOpenClass type) {
        super(syntaxNode, new IBoundNode[]{conditionNode, thenNode, elseNode});
        this.conditionNode = conditionNode;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
        this.type = type;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        Object res = this.conditionNode.evaluate(env);
        return Boolean.TRUE.equals(res) ? this.thenNode.evaluate(env) : (this.elseNode != null ? this.elseNode.evaluate(env) : null);
    }

    public IOpenClass getType() {
        return this.type;
    }
}

