/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BinaryOperatorNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.IndexNode;
import org.openl.binding.impl.MethodBasedIndex;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;

public class IndexNodeBinder
extends ANodeBinder {
    public static final String INDEX_METHOD_NAME = "index";

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        BindHelper.processError((String)"This node always binds  with target", (ISyntaxNode)node, (IBindingContext)bindingContext);
        return new ErrorBoundNode(node);
    }

    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) throws Exception {
        if (node.getNumberOfChildren() != 1) {
            BindHelper.processError((String)"Index node must have  exactly 1 subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        IBoundNode[] children = IndexNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        IOpenClass indexExprType = children[0].getType();
        IOpenClass containerType = targetNode.getType();
        IOpenClass[] types = new IOpenClass[]{containerType, indexExprType};
        IOpenIndex index = this.getMethodBasedIndex(types, bindingContext);
        if (index != null) {
            return new IndexNode(node, children, targetNode, index);
        }
        IAggregateInfo info = containerType.getAggregateInfo();
        if (info != null && (index = info.getIndex(containerType, indexExprType)) != null) {
            return new IndexNode(node, children, targetNode, index);
        }
        String message = String.format("Index operator %s[%s] is not found", targetNode.getType(), indexExprType.getName());
        BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
        return new ErrorBoundNode(node);
    }

    private IOpenIndex getMethodBasedIndex(IOpenClass[] types, IBindingContext bindingContext) {
        IMethodCaller reader = BinaryOperatorNodeBinder.findBinaryOperatorMethodCaller((String)INDEX_METHOD_NAME, (IOpenClass[])types, (IBindingContext)bindingContext);
        if (reader == null) {
            IOpenClass[] params = new IOpenClass[]{types[1]};
            reader = MethodSearch.findMethod((String)INDEX_METHOD_NAME, (IOpenClass[])params, (ICastFactory)bindingContext, (IMethodFactory)types[0]);
        }
        if (reader == null) {
            return null;
        }
        IOpenClass returnType = reader.getMethod().getType();
        IMethodCaller writer = bindingContext.findMethodCaller("org.openl.operators", INDEX_METHOD_NAME, new IOpenClass[]{types[0], types[1], returnType});
        if (writer == null) {
            IOpenClass[] params = new IOpenClass[]{types[1], returnType};
            writer = MethodSearch.findMethod((String)INDEX_METHOD_NAME, (IOpenClass[])params, (ICastFactory)bindingContext, (IMethodFactory)types[0]);
        }
        return new MethodBasedIndex(reader, writer);
    }
}

