/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.MethodHeaderNode;
import org.openl.binding.impl.module.MethodParametersNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.text.ILocation;

public class MethodHeaderNodeBinder
extends ANodeBinder {
    private static final int TYPE_NODE = 0;
    private static final int METHOD_NAME_NODE = 1;
    private static final int PARAMETERS_NODE = 2;

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode typeNode = MethodHeaderNodeBinder.bindChildNode((ISyntaxNode)node.getChild(0), (IBindingContext)bindingContext);
        String methodName = ((IdentifierNode)node.getChild(1)).getIdentifier();
        ISyntaxNode parametersNode = node.getChild(2);
        MethodParametersNode boundParametersNode = (MethodParametersNode)MethodHeaderNodeBinder.bindChildNode((ISyntaxNode)parametersNode, (IBindingContext)bindingContext);
        IMethodSignature signature = boundParametersNode.getSignature();
        ILocation typeLocation = null;
        ILocation[] paramTypeLocations = null;
        if (!bindingContext.isExecutionMode()) {
            ISyntaxNode syntaxNode = typeNode.getSyntaxNode();
            while (syntaxNode.getNumberOfChildren() == 1 && !(syntaxNode instanceof IdentifierNode)) {
                syntaxNode = syntaxNode.getChild(0);
            }
            typeLocation = syntaxNode.getSourceLocation();
            paramTypeLocations = new ILocation[signature.getNumberOfParameters()];
            for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
                paramTypeLocations[i] = boundParametersNode.getParamTypeLocation(i);
            }
        }
        OpenMethodHeader header = new OpenMethodHeader(methodName, typeNode.getType(), signature, null, typeLocation, paramTypeLocations);
        return new MethodHeaderNode(node, (IOpenMethodHeader)header);
    }
}

