/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Method;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.ArrayArgumentsMethodBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.cast.AutoCastFactory;
import org.openl.binding.impl.cast.AutoCastReturnType;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.binding.impl.method.VarArgsOpenMethod;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.java.JavaOpenMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNodeBinder
extends ANodeBinder {
    private final Logger log = LoggerFactory.getLogger(MethodNodeBinder.class);

    private IMethodCaller autoCastReturnTypeWrap(IBindingContext bindingContext, IMethodCaller methodCaller, IOpenClass[] parameterTypes) {
        Method javaMethod;
        AutoCastReturnType autoCastReturnType;
        VarArgsOpenMethod varArgsOpenMethod;
        CastingMethodCaller castingMethodCaller;
        JavaOpenMethod method = null;
        if (methodCaller instanceof CastingMethodCaller && (castingMethodCaller = (CastingMethodCaller)methodCaller).getMethod() instanceof JavaOpenMethod) {
            method = (JavaOpenMethod)castingMethodCaller.getMethod();
        }
        if (methodCaller instanceof VarArgsOpenMethod && (varArgsOpenMethod = (VarArgsOpenMethod)methodCaller).getDelegate() instanceof JavaOpenMethod) {
            method = (JavaOpenMethod)varArgsOpenMethod.getDelegate();
        }
        if (methodCaller instanceof JavaOpenMethod) {
            method = (JavaOpenMethod)methodCaller;
        }
        if (method instanceof JavaOpenMethod && (autoCastReturnType = (javaMethod = method.getJavaMethod()).getAnnotation(AutoCastReturnType.class)) != null) {
            Class clazz = autoCastReturnType.value();
            try {
                AutoCastFactory autoCastFactory = (AutoCastFactory)clazz.newInstance();
                return autoCastFactory.build(bindingContext, methodCaller, method, parameterTypes);
            }
            catch (IllegalAccessException | InstantiationException e) {
                return method;
            }
        }
        return methodCaller;
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode errorNode = this.validateNode(node, bindingContext);
        if (errorNode != null) {
            return errorNode;
        }
        int childrenCount = node.getNumberOfChildren();
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IBoundNode[] children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1));
        if (MethodNodeBinder.hasErrorBoundNode((IBoundNode[])children)) {
            return new ErrorBoundNode(node);
        }
        IOpenClass[] parameterTypes = MethodNodeBinder.getTypes((IBoundNode[])children);
        IMethodCaller methodCaller = bindingContext.findMethodCaller("org.openl.this", methodName, parameterTypes);
        BindHelper.checkOnDeprecation((ISyntaxNode)node, (IBindingContext)bindingContext, (IMethodCaller)methodCaller);
        methodCaller = this.autoCastReturnTypeWrap(bindingContext, methodCaller, parameterTypes);
        if (methodCaller != null) {
            this.log(methodName, parameterTypes, "entirely appropriate by signature method");
            return new MethodBoundNode(node, children, methodCaller);
        }
        if (childrenCount > 1) {
            return this.bindWithAdditionalBinders(node, bindingContext, methodName, parameterTypes, children, childrenCount);
        }
        return this.methodNotFoundError(node, bindingContext, methodName, parameterTypes, null);
    }

    protected IBoundNode makeArrayParametersMethod(ISyntaxNode methodNode, IBindingContext bindingContext, String methodName, IOpenClass[] argumentTypes, IBoundNode[] children) throws Exception {
        return new ArrayArgumentsMethodBinder(methodName, argumentTypes, children).bind(methodNode, bindingContext);
    }

    protected IBoundNode bindWithAdditionalBinders(ISyntaxNode methodNode, IBindingContext bindingContext, String methodName, IOpenClass[] argumentTypes, IBoundNode[] children, int childrenCount) throws Exception {
        IOpenField field;
        IBoundNode arrayParametersMethod = this.makeArrayParametersMethod(methodNode, bindingContext, methodName, argumentTypes, children);
        if (arrayParametersMethod != null) {
            this.log(methodName, argumentTypes, "array argument method");
            return arrayParametersMethod;
        }
        IOpenClass argumentType = argumentTypes[0];
        int dims = 0;
        while (argumentType.isArray()) {
            ++dims;
            argumentType = argumentType.getComponentClass();
        }
        if (childrenCount == 2 && (field = bindingContext.findFieldFor(argumentType, methodName, false)) != null) {
            this.log(methodName, argumentTypes, "field access method");
            return new FieldBoundNode(methodNode, field, children[0], dims);
        }
        return this.methodNotFoundError(methodNode, bindingContext, methodName, argumentTypes, null);
    }

    private void log(String methodName, IOpenClass[] argumentTypes, String bindingType) {
        if (this.log.isTraceEnabled()) {
            String method = MethodUtil.printMethod((String)methodName, (IOpenClass[])argumentTypes);
            this.log.trace("Method {} was binded as {}", (Object)method, (Object)bindingType);
        }
    }

    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) throws Exception {
        IBoundNode errorNode = this.validateNode(node, bindingContext);
        if (errorNode != null) {
            return errorNode;
        }
        int childrenCount = node.getNumberOfChildren();
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IBoundNode[] children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1));
        IOpenClass[] types = MethodNodeBinder.getTypes((IBoundNode[])children);
        IOpenClass type = target.getType();
        IMethodCaller methodCaller = MethodSearch.findMethod((String)methodName, (IOpenClass[])types, (ICastFactory)bindingContext, (IMethodFactory)type);
        BindHelper.checkOnDeprecation((ISyntaxNode)node, (IBindingContext)bindingContext, (IMethodCaller)methodCaller);
        if (methodCaller == null) {
            return this.methodNotFoundError(node, bindingContext, methodName, types, type);
        }
        errorNode = this.validateMethod(node, bindingContext, target, methodCaller);
        if (errorNode != null) {
            return errorNode;
        }
        return new MethodBoundNode(node, children, methodCaller, target);
    }

    private IBoundNode validateMethod(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target, IMethodCaller methodCaller) {
        boolean methodIsStatic = methodCaller.getMethod().isStatic();
        if (target.isStaticTarget() != methodIsStatic) {
            if (methodIsStatic) {
                BindHelper.processWarn((String)"Access of a static method from non-static object", (ISyntaxNode)node, (IBindingContext)bindingContext);
            } else {
                BindHelper.processError((String)"Access of a non-static method from a static object", (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
                return new ErrorBoundNode(node);
            }
        }
        return null;
    }

    private IBoundNode methodNotFoundError(ISyntaxNode node, IBindingContext bindingContext, String methodName, IOpenClass[] types, IOpenClass target) {
        StringBuilder buf = new StringBuilder("Method '");
        MethodUtil.printMethod((String)methodName, (IOpenClass[])types, (StringBuilder)buf);
        buf.append("' is not found");
        if (target != null) {
            buf.append("in '").append(target.getName()).append("'");
        }
        BindHelper.processError((String)buf.toString(), (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
        return new ErrorBoundNode(node);
    }

    private IBoundNode validateNode(ISyntaxNode node, IBindingContext bindingContext) {
        if (node.getNumberOfChildren() < 1) {
            BindHelper.processError((String)"New node should have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        return null;
    }
}

