/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.math.BigInteger;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class NegativeIntNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children = NegativeIntNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        LiteralBoundNode child = (LiteralBoundNode)children[0];
        Number value = (Number)child.getValue();
        if (value instanceof Integer) {
            return new LiteralBoundNode(node, (Object)(-value.intValue()), (IOpenClass)JavaOpenClass.INT);
        }
        if (value instanceof Long) {
            return new LiteralBoundNode(node, (Object)(-value.longValue()), (IOpenClass)JavaOpenClass.LONG);
        }
        if (value instanceof BigInteger) {
            return new LiteralBoundNode(node, (Object)((BigInteger)value).negate(), (IOpenClass)JavaOpenClass.getOpenClass(BigInteger.class));
        }
        throw new RuntimeException("Unsupported integer type: " + value.getClass());
    }
}

