/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BaseAggregateIndexNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.NullOpenClass;
import org.openl.vm.IRuntimeEnv;

public class OrderByIndexNodeBinder
extends BaseAggregateIndexNodeBinder {
    private static final String TEMPORARY_VAR_NAME = "OrderByIndex";

    @Override
    public String getDefaultTempVarName(IBindingContext bindingContext) {
        return BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)TEMPORARY_VAR_NAME);
    }

    @Override
    protected IBoundNode createBoundNode(ISyntaxNode node, IBoundNode targetNode, IBoundNode expressionNode, ILocalVar localVar) {
        boolean isDecreasing = node.getType().contains("decreasing");
        return new OrderByIndexNode(node, targetNode, expressionNode, localVar, isDecreasing);
    }

    @Override
    protected IBoundNode validateExpressionNode(IBoundNode expressionNode, IBindingContext bindingContext) {
        if (expressionNode == null) {
            return null;
        }
        IOpenClass type = expressionNode.getType();
        Class instanceClass = type.getInstanceClass();
        if (Comparable.class.isAssignableFrom(instanceClass)) {
            return expressionNode;
        }
        if (instanceClass.isPrimitive() && instanceClass != Void.TYPE) {
            return expressionNode;
        }
        if (type != NullOpenClass.the) {
            BindHelper.processError((String)"Order By expression must be Comparable", (ISyntaxNode)expressionNode.getSyntaxNode(), (IBindingContext)bindingContext, (boolean)false);
        }
        return new ErrorBoundNode(expressionNode.getSyntaxNode());
    }

    private static class OrderByIndexNode
    extends ABoundNode {
        private ILocalVar tempVar;
        private boolean isDecreasing;
        private IBoundNode orderBy;
        private IBoundNode targetNode;

        OrderByIndexNode(ISyntaxNode syntaxNode, IBoundNode targetNode, IBoundNode orderBy, ILocalVar tempVar, boolean isDecreasing) {
            super(syntaxNode, new IBoundNode[]{targetNode, orderBy});
            this.tempVar = tempVar;
            this.isDecreasing = isDecreasing;
            this.orderBy = orderBy;
            this.targetNode = targetNode;
        }

        protected Object evaluateRuntime(IRuntimeEnv env) {
            IAggregateInfo aggregateInfo = this.targetNode.getType().getAggregateInfo();
            Object container = this.targetNode.evaluate(env);
            Iterator elementsIterator = aggregateInfo.getIterator(container);
            TreeMap<Comparable, Object> map = new TreeMap<Comparable, Object>();
            int size = 0;
            while (elementsIterator.hasNext()) {
                Object element = elementsIterator.next();
                this.tempVar.set(null, element, env);
                Comparable key = (Comparable)this.orderBy.evaluate(env);
                Object prev = map.put(key, element);
                if (prev != null) {
                    OrderList list;
                    if (prev.getClass() != OrderList.class) {
                        list = new OrderList();
                        list.add(prev);
                    } else {
                        list = (OrderList)prev;
                    }
                    list.add(element);
                    map.put(key, list);
                }
                ++size;
            }
            Object result = aggregateInfo.makeIndexedAggregate(aggregateInfo.getComponentType(this.getType()), new int[]{size});
            IOpenIndex index = aggregateInfo.getIndex(this.targetNode.getType());
            int idx = 0;
            for (Object element : map.values()) {
                if (element.getClass() != OrderList.class) {
                    index.setValue(result, (Object)this.nextIdx(idx++, size), element);
                    continue;
                }
                OrderList list = (OrderList)element;
                for (int i = 0; i < list.size(); ++i) {
                    index.setValue(result, (Object)this.nextIdx(idx++, size), list.get(i));
                }
            }
            return result;
        }

        private int nextIdx(int idx, int size) {
            return this.isDecreasing ? size - 1 - idx : idx;
        }

        public IOpenClass getType() {
            IOpenClass type = this.targetNode.getType();
            if (type.isArray()) {
                return type;
            }
            if (type.getAggregateInfo() != null && type.getAggregateInfo().isAggregate(type)) {
                return type;
            }
            IOpenClass varType = this.tempVar.getType();
            return varType.getAggregateInfo().getIndexedAggregateType(varType, 1);
        }
    }

    private static class OrderList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OrderList() {
        }
    }
}

