/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenField;
import org.openl.util.text.TextInfo;

public class RangeVariableBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        String text = node.getModule().getCode();
        TextInfo info = new TextInfo(text);
        SubTextSourceCodeModule sourceModule = new SubTextSourceCodeModule(node.getModule(), node.getSourceLocation().getStart().getAbsolutePosition(info), node.getSourceLocation().getEnd().getAbsolutePosition(info) + 1);
        IdentifierNode[] rangeParts = Tokenizer.tokenize((IOpenSourceCodeModule)sourceModule, (String)":");
        if (rangeParts.length != 2) {
            return this.error("Wrong Range format: " + sourceModule.getCode(), node, bindingContext);
        }
        IOpenField om = bindingContext.findRange("org.openl.this", rangeParts[0].getIdentifier(), rangeParts[1].getIdentifier());
        if (om != null) {
            return new FieldBoundNode(node, om);
        }
        return null;
    }

    private IBoundNode error(String message, ISyntaxNode node, IBindingContext bindingContext) {
        BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
        return new ErrorBoundNode(node);
    }
}

