/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BaseAggregateIndexNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.util.BooleanUtils;
import org.openl.vm.IRuntimeEnv;

public class SelectAllIndexNodeBinder
extends BaseAggregateIndexNodeBinder {
    private static final String TEMPORARY_VAR_NAME = "selectAllIndex";

    @Override
    public String getDefaultTempVarName(IBindingContext bindingContext) {
        return BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)TEMPORARY_VAR_NAME);
    }

    @Override
    protected IBoundNode createBoundNode(ISyntaxNode node, IBoundNode targetNode, IBoundNode expressionNode, ILocalVar localVar) {
        return new ConditionalSelectIndexNode(node, targetNode, expressionNode, localVar);
    }

    @Override
    protected IBoundNode validateExpressionNode(IBoundNode expressionNode, IBindingContext bindingContext) {
        return BindHelper.checkConditionBoundNode((IBoundNode)expressionNode, (IBindingContext)bindingContext);
    }

    private static class ConditionalSelectIndexNode
    extends ABoundNode {
        private ILocalVar tempVar;
        private IBoundNode condition;
        private IBoundNode targetNode;

        ConditionalSelectIndexNode(ISyntaxNode syntaxNode, IBoundNode targetNode, IBoundNode condition, ILocalVar tempVar) {
            super(syntaxNode, new IBoundNode[]{targetNode, condition});
            this.tempVar = tempVar;
            this.targetNode = targetNode;
            this.condition = condition;
        }

        protected Object evaluateRuntime(IRuntimeEnv env) {
            IAggregateInfo aggregateInfo = this.targetNode.getType().getAggregateInfo();
            Iterator elementsIterator = aggregateInfo.getIterator(this.targetNode.evaluate(env));
            ArrayList firedElements = new ArrayList();
            while (elementsIterator.hasNext()) {
                Object element = elementsIterator.next();
                this.tempVar.set(null, element, env);
                if (!BooleanUtils.toBoolean((Object)this.condition.evaluate(env))) continue;
                firedElements.add(element);
            }
            Object result = aggregateInfo.makeIndexedAggregate(this.tempVar.getType(), new int[]{firedElements.size()});
            IOpenIndex index = aggregateInfo.getIndex(this.targetNode.getType());
            for (int i = 0; i < firedElements.size(); ++i) {
                index.setValue(result, (Object)i, firedElements.get(i));
            }
            return result;
        }

        public IOpenClass getType() {
            IOpenClass type = this.targetNode.getType();
            if (type.isArray()) {
                return type;
            }
            if (type.getAggregateInfo() != null && type.getAggregateInfo().isAggregate(type)) {
                return type;
            }
            IOpenClass varType = this.tempVar.getType();
            return varType.getAggregateInfo().getIndexedAggregateType(varType, 1);
        }
    }
}

