/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BaseAggregateIndexNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SplitByIndexNodeBinder
extends BaseAggregateIndexNodeBinder {
    private static final String TEMPORARY_VAR_NAME = "SplitByIndex";

    @Override
    public String getDefaultTempVarName(IBindingContext bindingContext) {
        return BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)TEMPORARY_VAR_NAME);
    }

    @Override
    protected IBoundNode createBoundNode(ISyntaxNode node, IBoundNode targetNode, IBoundNode expressionNode, ILocalVar localVar) {
        return new SplitByIndexNode(node, targetNode, expressionNode, localVar);
    }

    @Override
    protected IBoundNode validateExpressionNode(IBoundNode expressionNode, IBindingContext bindingContext) {
        return expressionNode;
    }

    private static class SplitByIndexNode
    extends ABoundNode {
        private ILocalVar tempVar;
        private IBoundNode splitBy;
        private IBoundNode targetNode;

        SplitByIndexNode(ISyntaxNode syntaxNode, IBoundNode targetNode, IBoundNode splitBy, ILocalVar tempVar) {
            super(syntaxNode, new IBoundNode[]{targetNode, splitBy});
            this.tempVar = tempVar;
            this.targetNode = targetNode;
            this.splitBy = splitBy;
        }

        protected Object evaluateRuntime(IRuntimeEnv env) {
            IOpenClass containerType = this.targetNode.getType();
            IAggregateInfo aggregateInfo = containerType.getAggregateInfo();
            Object container = this.targetNode.evaluate(env);
            Iterator elementsIterator = aggregateInfo.getIterator(container);
            Object tempKey = new Object();
            HashMap map = new HashMap();
            ArrayList list2d = new ArrayList();
            while (elementsIterator.hasNext()) {
                ArrayList list;
                Object element = elementsIterator.next();
                this.tempVar.set(null, element, env);
                Object key = this.splitBy.evaluate(env);
                if (key == null) {
                    key = tempKey;
                }
                if ((list = (ArrayList)map.get(key)) == null) {
                    list = new ArrayList();
                    map.put(key, list);
                    list2d.add(list);
                }
                list.add(element);
            }
            int size = list2d.size();
            IOpenClass componentType = this.tempVar.getType();
            IOpenClass arrayType = componentType.getAggregateInfo().getIndexedAggregateType(componentType, 1);
            Object result = componentType.getAggregateInfo().makeIndexedAggregate(arrayType, new int[]{size});
            for (int i = 0; i < size; ++i) {
                ArrayList list = (ArrayList)list2d.get(i);
                int listSize = list.size();
                Object ary = componentType.getAggregateInfo().makeIndexedAggregate(componentType, new int[]{listSize});
                for (int j = 0; j < listSize; ++j) {
                    Array.set(ary, j, list.get(j));
                }
                Array.set(result, i, ary);
            }
            return result;
        }

        public IOpenClass getType() {
            IOpenClass containerType = this.targetNode.getType();
            if (containerType.isArray()) {
                IAggregateInfo info = containerType.getAggregateInfo();
                return info.getIndexedAggregateType(containerType, 1);
            }
            IOpenClass componentType = this.tempVar.getType();
            IAggregateInfo info = componentType.getAggregateInfo();
            return info.getIndexedAggregateType(componentType, 2);
        }
    }
}

