/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BaseAggregateIndexNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class TransformIndexNodeBinder
extends BaseAggregateIndexNodeBinder {
    private static final String TEMPORARY_VAR_NAME = "selectAllIndex";

    @Override
    public String getDefaultTempVarName(IBindingContext bindingContext) {
        return BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)TEMPORARY_VAR_NAME);
    }

    @Override
    protected IBoundNode createBoundNode(ISyntaxNode node, IBoundNode targetNode, IBoundNode expressionNode, ILocalVar localVar) {
        boolean isUnique = node.getType().contains("unique");
        return new TransformIndexNode(node, targetNode, expressionNode, localVar, isUnique);
    }

    @Override
    protected IBoundNode validateExpressionNode(IBoundNode expressionNode, IBindingContext bindingContext) {
        return expressionNode;
    }

    private static class TransformIndexNode
    extends ABoundNode {
        private ILocalVar tempVar;
        private boolean isUnique;
        private IBoundNode transformer;
        private IBoundNode targetNode;

        TransformIndexNode(ISyntaxNode syntaxNode, IBoundNode targetNode, IBoundNode transformer, ILocalVar tempVar, boolean isUnique) {
            super(syntaxNode, new IBoundNode[]{targetNode, transformer});
            this.tempVar = tempVar;
            this.isUnique = isUnique;
            this.targetNode = targetNode;
            this.transformer = transformer;
        }

        protected Object evaluateRuntime(IRuntimeEnv env) {
            IAggregateInfo aggregateInfo = this.getType().getAggregateInfo();
            Iterator elementsIterator = this.targetNode.getType().getAggregateInfo().getIterator(this.targetNode.evaluate(env));
            ArrayList<Object> firedElements = new ArrayList<Object>();
            HashSet<Object> uniqueSet = null;
            if (this.isUnique) {
                uniqueSet = new HashSet<Object>();
            }
            while (elementsIterator.hasNext()) {
                Object element = elementsIterator.next();
                this.tempVar.set(null, element, env);
                Object transformed = this.transformer.evaluate(env);
                if (this.isUnique) {
                    if (!uniqueSet.add(transformed)) continue;
                    firedElements.add(transformed);
                    continue;
                }
                firedElements.add(transformed);
            }
            Object result = aggregateInfo.makeIndexedAggregate(this.transformer.getType(), new int[]{firedElements.size()});
            for (int i = 0; i < firedElements.size(); ++i) {
                Array.set(result, i, firedElements.get(i));
            }
            return result;
        }

        public IOpenClass getType() {
            IOpenClass targetType = this.transformer.getType();
            return targetType.getAggregateInfo().getIndexedAggregateType(targetType, 1);
        }
    }
}

