/*
 * Decompiled with CFR 0.152.
 */
package org.openl;

import java.util.Collection;
import java.util.List;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.syntax.exception.CompositeOpenlException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;

public class CompiledOpenClass {
    private SyntaxNodeException[] parsingErrors;
    private SyntaxNodeException[] bindingErrors;
    private List<OpenLMessage> messages;
    private IOpenClass openClass;
    private ClassLoader classLoader;

    public CompiledOpenClass(IOpenClass openClass, List<OpenLMessage> messages, SyntaxNodeException[] parsingErrors, SyntaxNodeException[] bindingErrors) {
        this.openClass = openClass;
        this.parsingErrors = parsingErrors;
        this.bindingErrors = bindingErrors;
        this.messages = messages;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Deprecated
    public SyntaxNodeException[] getBindingErrors() {
        return this.bindingErrors;
    }

    public IOpenClass getOpenClass() {
        this.throwErrorExceptionsIfAny();
        return this.openClass;
    }

    public IOpenClass getOpenClassWithErrors() {
        return this.openClass;
    }

    @Deprecated
    public SyntaxNodeException[] getParsingErrors() {
        return this.parsingErrors;
    }

    public boolean hasErrors() {
        List<OpenLMessage> errorMessages = this.getErrorMessages();
        return this.parsingErrors.length > 0 || this.bindingErrors.length > 0 || errorMessages != null && !errorMessages.isEmpty();
    }

    private List<OpenLMessage> getErrorMessages() {
        return OpenLMessagesUtils.filterMessagesBySeverity(this.getMessages(), Severity.ERROR);
    }

    public void throwErrorExceptionsIfAny() {
        if (this.parsingErrors.length > 0) {
            throw new CompositeOpenlException("Parsing Error(s):", this.parsingErrors, this.getErrorMessages());
        }
        if (this.bindingErrors.length > 0) {
            throw new CompositeOpenlException("Binding Error(s):", this.bindingErrors, this.getErrorMessages());
        }
        if (this.getErrorMessages().size() > 0) {
            throw new CompositeOpenlException("Module contains critical errors", null, this.getErrorMessages());
        }
    }

    public List<OpenLMessage> getMessages() {
        return this.messages;
    }

    public Collection<IOpenClass> getTypes() {
        if (this.openClass == null) {
            return null;
        }
        return this.openClass.getTypes();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

