/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding;

import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.util.ClassUtils;
import org.openl.util.IConvertor;
import org.openl.util.print.DefaultFormat;

public class MethodUtil {
    private static final IConvertor<IOpenClass, String> DEFAULT_TYPE_CONVERTER = new IConvertor<IOpenClass, String>(){

        public String convert(IOpenClass type) {
            return MethodUtil.printType(type);
        }
    };

    public static String printType(IOpenClass type) {
        return type.getDisplayName(0);
    }

    public static StringBuilder printMethod(IOpenMethodHeader method, StringBuilder buf) {
        buf.append((String)DEFAULT_TYPE_CONVERTER.convert((Object)method.getType())).append(' ');
        MethodUtil.printMethod(method, buf, DEFAULT_TYPE_CONVERTER);
        return buf;
    }

    public static String printSignature(IOpenMethodHeader methodHeader, final int mode) {
        StringBuilder buf = new StringBuilder(100);
        IConvertor<IOpenClass, String> typeConverter = new IConvertor<IOpenClass, String>(){

            public String convert(IOpenClass type) {
                return type.getDisplayName(mode);
            }
        };
        MethodUtil.printMethod(methodHeader, buf, typeConverter);
        return buf.toString();
    }

    private static void printMethod(IOpenMethodHeader methodHeader, StringBuilder buf, IConvertor<IOpenClass, String> typeConverter) {
        MethodUtil.startPrintingMethodName(methodHeader.getName(), buf);
        IMethodSignature signature = methodHeader.getSignature();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String type = (String)typeConverter.convert((Object)signature.getParameterType(i));
            String name = signature.getParameterName(i);
            if (i != 0) {
                buf.append(", ");
            }
            if (type != null) {
                buf.append(type);
            }
            if (type != null && name != null) {
                buf.append(' ');
            }
            if (name == null) continue;
            buf.append(name);
        }
        MethodUtil.endPrintingMethodName(buf);
    }

    public static String printMethod(String name, Class<?>[] params) {
        return MethodUtil.printMethod(name, params, new StringBuilder()).toString();
    }

    public static StringBuilder printMethod(String name, Class<?>[] params, StringBuilder buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            String type = params[i].getName();
            if (i != 0) {
                buf.append(", ");
            }
            if (type == null) continue;
            buf.append(type);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethod(String name, IOpenClass[] params) {
        return MethodUtil.printMethod(name, params, new StringBuilder()).toString();
    }

    public static StringBuilder printMethod(String name, IOpenClass[] params, StringBuilder buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            String type = params[i].getName();
            if (i != 0) {
                buf.append(", ");
            }
            if (type == null) continue;
            buf.append(type);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethodWithParameterValues(IOpenMethodHeader method, Object[] params) {
        StringBuilder buf = new StringBuilder();
        MethodUtil.startPrintingMethodName(method.getName(), buf);
        IMethodSignature signature = method.getSignature();
        for (int i = 0; i < params.length; ++i) {
            String name = signature.getParameterName(i);
            if (i != 0) {
                buf.append(", ");
            }
            if (name != null) {
                buf.append(name);
            }
            if (params[i] == null) continue;
            buf.append(" = ");
            DefaultFormat.format((Object)params[i], (StringBuilder)buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf.toString();
    }

    private static void startPrintingMethodName(String name, StringBuilder buf) {
        buf.append(name).append('(');
    }

    private static void endPrintingMethodName(StringBuilder buf) {
        buf.append(')');
    }

    public static Method getMatchingAccessibleMethod(Class<?> methodOwner, String methodName, Class<?>[] argTypes) {
        Method[] methods;
        Method resultMethod = null;
        for (Method method : methods = methodOwner.getMethods()) {
            Class<?>[] signatureParams = method.getParameterTypes();
            if (!methodName.equals(method.getName()) || signatureParams.length != argTypes.length || !MethodUtil.isAssignable(argTypes, signatureParams) || (method = MethodUtils.getAccessibleMethod((Method)method)) == null) continue;
            resultMethod = resultMethod != null ? MethodUtil.getCloserMethod(resultMethod, method, argTypes) : method;
        }
        return resultMethod;
    }

    private static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> from = classArray[i];
            Class<?> to = toClassArray[i];
            if (!(from.isPrimitive() ^ to.isPrimitive()) && ClassUtils.isAssignable(from, to)) continue;
            return false;
        }
        return true;
    }

    private static Method getCloserMethod(Method firstMethod, Method secondMethod, Class<?>[] argTypes) {
        int firstTransfCount = MethodUtil.getTransformationsCount(firstMethod.getParameterTypes(), argTypes);
        if (firstTransfCount < 0) {
            return secondMethod;
        }
        int secondTransfCount = MethodUtil.getTransformationsCount(secondMethod.getParameterTypes(), argTypes);
        if (secondTransfCount < 0 || secondTransfCount >= firstTransfCount) {
            return firstMethod;
        }
        return secondMethod;
    }

    private static int getTransformationsCount(Class<?>[] signatureToCheck, Class<?>[] argTypes) {
        if (!MethodUtil.isAssignable(argTypes, signatureToCheck)) {
            return -1;
        }
        int transformationsCount = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (signatureToCheck[i].equals(argTypes[i])) continue;
            ++transformationsCount;
        }
        return transformationsCount;
    }
}

