/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ControlSignal;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.vm.IRuntimeEnv;

public abstract class ABoundNode
implements IBoundNode {
    private static final IBoundNode[] EMPTY = new IBoundNode[0];
    protected ISyntaxNode syntaxNode;
    protected IBoundNode[] children;

    protected ABoundNode(ISyntaxNode syntaxNode, IBoundNode ... children) {
        this.syntaxNode = syntaxNode;
        this.children = children != null && children.length == 0 ? EMPTY : children;
    }

    @Override
    public void assign(Object value, IRuntimeEnv env) throws OpenLRuntimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object evaluate(IRuntimeEnv env) throws OpenLRuntimeException {
        try {
            return this.evaluateRuntime(env);
        }
        catch (OpenLRuntimeException ore) {
            throw ore;
        }
        catch (ControlSignal controlSignal) {
            throw controlSignal;
        }
        catch (Throwable t) {
            throw new OpenLRuntimeException(t, (IBoundNode)this);
        }
    }

    protected abstract Object evaluateRuntime(IRuntimeEnv var1) throws Exception;

    @Override
    public IOpenClass getType() {
        return NullOpenClass.the;
    }

    public Object[] evaluateChildren(IRuntimeEnv env) throws OpenLRuntimeException {
        if (this.children == null) {
            return null;
        }
        Object[] ch = new Object[this.children.length];
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = this.children[i].evaluate(env);
        }
        return ch;
    }

    @Override
    public IBoundNode[] getChildren() {
        return this.children;
    }

    @Override
    public ISyntaxNode getSyntaxNode() {
        return this.syntaxNode;
    }

    public void setSyntaxNode(ISyntaxNode syntaxNode) {
        this.syntaxNode = syntaxNode;
    }

    @Override
    public IBoundNode getTargetNode() {
        return null;
    }

    @Override
    public boolean isLvalue() {
        return false;
    }

    @Override
    public void updateAssignFieldDependency(BindingDependencies dependencies) {
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
    }

    @Override
    public boolean isStaticTarget() {
        return false;
    }
}

