/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.vm.IRuntimeEnv;

public class BinaryOpNode
extends MethodBoundNode {
    private boolean useBinaryMethod;

    public static Object evaluateBinaryMethod(IRuntimeEnv env, Object[] pars, IMethodCaller boundMethod) {
        if (boundMethod.getMethod().getSignature().getParameterTypes().length == 2) {
            return boundMethod.invoke(null, pars, env);
        }
        return boundMethod.invoke(pars[0], new Object[]{pars[1]}, env);
    }

    public BinaryOpNode(ISyntaxNode syntaxNode, IBoundNode[] child, IMethodCaller method) {
        super(syntaxNode, child, method);
        this.useBinaryMethod = method.getMethod().getSignature().getParameterTypes().length == 2;
    }

    @Override
    protected Object evaluateRuntime(IRuntimeEnv env) {
        Object[] pars = this.evaluateChildren(env);
        if (this.useBinaryMethod) {
            return this.boundMethod.invoke(null, pars, env);
        }
        return this.boundMethod.invoke(pars[0], new Object[]{pars[1]}, env);
    }
}

