/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BinaryMethodCallerSwapParams;
import org.openl.binding.impl.BinaryOpNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

public class BinaryOperatorNodeBinder
extends ANodeBinder {
    private static Map<String, String> inverseMethod = new HashMap<String, String>(6){
        {
            this.put("le", "ge");
            this.put("lt", "gt");
            this.put("ge", "le");
            this.put("gt", "lt");
            this.put("eq", "eq");
            this.put("add", "add");
        }
    };

    public static IBoundNode bindOperator(ISyntaxNode node, String operatorName, IBoundNode b1, IBoundNode b2, IBindingContext bindingContext) throws SyntaxNodeException {
        IOpenClass[] types = new IOpenClass[]{b1.getType(), b2.getType()};
        IMethodCaller methodCaller = BinaryOperatorNodeBinder.findBinaryOperatorMethodCaller(operatorName, types, bindingContext);
        if (methodCaller == null) {
            if (!NullOpenClass.isAnyNull(types)) {
                String message = BinaryOperatorNodeBinder.errorMsg(operatorName, types[0], types[1]);
                BindHelper.processError(message, node, bindingContext, false);
            }
            return new ErrorBoundNode(node);
        }
        return new BinaryOpNode(node, new IBoundNode[]{b1, b2}, methodCaller);
    }

    public static String errorMsg(String methodName, IOpenClass t1, IOpenClass t2) {
        return "Operator not defined for: " + methodName + "(" + t1.getName() + ", " + t2.getName() + ")";
    }

    public static IMethodCaller findBinaryOperatorMethodCaller(String methodName, IOpenClass[] types, IBindingContext bindingContext) {
        IOpenClass[] invTypes;
        IMethodCaller methodCaller = BinaryOperatorNodeBinder.findSingleBinaryOperatorMethodCaller(methodName, types, bindingContext);
        if (methodCaller != null) {
            return methodCaller;
        }
        String inverse = inverseMethod.get(methodName);
        if (inverse != null && (methodCaller = BinaryOperatorNodeBinder.findSingleBinaryOperatorMethodCaller(inverse, invTypes = new IOpenClass[]{types[1], types[0]}, bindingContext)) != null) {
            return new BinaryMethodCallerSwapParams(methodCaller);
        }
        return null;
    }

    private static IMethodCaller findSingleBinaryOperatorMethodCaller(String methodName, IOpenClass[] argumentTypes, IBindingContext bindingContext) {
        IMethodCaller methodCaller = bindingContext.findMethodCaller("org.openl.operators", methodName, argumentTypes);
        if (methodCaller != null) {
            return methodCaller;
        }
        IOpenClass[] types2 = new IOpenClass[]{argumentTypes[1]};
        methodCaller = MethodSearch.findMethod(methodName, types2, (ICastFactory)bindingContext, argumentTypes[0]);
        if (methodCaller != null) {
            return methodCaller;
        }
        methodCaller = MethodSearch.findMethod(methodName, argumentTypes, (ICastFactory)bindingContext, argumentTypes[0]);
        if (methodCaller != null) {
            return methodCaller;
        }
        methodCaller = MethodSearch.findMethod(methodName, argumentTypes, (ICastFactory)bindingContext, argumentTypes[1]);
        return methodCaller;
    }

    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        if (node.getNumberOfChildren() != 2) {
            throw SyntaxNodeExceptionUtils.createError("Binary node must have 2 subnodes", node);
        }
        int index = node.getType().lastIndexOf(46);
        String methodName = node.getType().substring(index + 1);
        IBoundNode[] children = BinaryOperatorNodeBinder.bindChildren(node, bindingContext);
        return BinaryOperatorNodeBinder.bindOperator(node, methodName, children[0], children[1], bindingContext);
    }
}

