/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BoundCode;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.message.OpenLMessagesUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenField;
import org.openl.types.java.JavaOpenMethod;

public class BindHelper {
    public static final String CONDITION_TYPE_MESSAGE = "Condition must have boolean type";
    private static final Collection<String> EQUAL_OPERATORS = Collections.unmodifiableCollection(Arrays.asList("op.binary.eq", "op.binary.strict_eq", "op.binary.le", "op.binary.strict_le", "op.binary.ge", "op.binary.strict_ge"));
    private static final Collection<String> NOT_EQUAL_OPERATORS = Collections.unmodifiableCollection(Arrays.asList("op.binary.ne", "op.binary.strict_ne", "op.binary.lt", "op.binary.strict_lt", "op.binary.gt", "op.binary.strict_gt"));

    private BindHelper() {
    }

    public static void processError(ISyntaxNode syntaxNode, Throwable throwable, IBindingContext bindingContext) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(throwable, syntaxNode);
        BindHelper.processError(error, bindingContext);
    }

    public static void processError(String message, ISyntaxNode syntaxNode, Throwable throwable, IBindingContext bindingContext) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(message, throwable, syntaxNode);
        BindHelper.processError(error, bindingContext);
    }

    public static void processError(CompositeSyntaxNodeException error, IBindingContext bindingContext) {
        SyntaxNodeException[] errors;
        for (SyntaxNodeException e : errors = error.getErrors()) {
            BindHelper.processError(e, bindingContext);
        }
    }

    public static void processError(SyntaxNodeException error, IBindingContext bindingContext) {
        bindingContext.addError(error);
        BindHelper.processError(error);
    }

    public static void processError(Throwable error, ISyntaxNode syntaxNode, IBindingContext bindingContext) {
        BindHelper.processError(error, syntaxNode, bindingContext, true);
    }

    public static void processError(Throwable error, ISyntaxNode syntaxNode, IBindingContext bindingContext, boolean storeGlobal) {
        SyntaxNodeException syntaxNodeException = SyntaxNodeExceptionUtils.createError(error, syntaxNode);
        BindHelper.processSyntaxNodeException(syntaxNodeException, storeGlobal, bindingContext);
    }

    public static void processError(String message, ISyntaxNode syntaxNode, IBindingContext bindingContext) {
        BindHelper.processError(message, syntaxNode, bindingContext, true);
    }

    public static void processError(String message, ISyntaxNode syntaxNode, IBindingContext bindingContext, boolean storeGlobal) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(message, syntaxNode);
        BindHelper.processSyntaxNodeException(error, storeGlobal, bindingContext);
    }

    private static void processSyntaxNodeException(SyntaxNodeException error, boolean storeGlobal, IBindingContext bindingContext) {
        bindingContext.addError(error);
        if (storeGlobal) {
            BindHelper.processError(error);
        }
    }

    public static void processError(String message, ISyntaxNode syntaxNode, Throwable throwable) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(message, throwable, syntaxNode);
        BindHelper.processError(error);
    }

    public static void processError(String message, ISyntaxNode syntaxNode) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(message, syntaxNode);
        BindHelper.processError(error);
    }

    public static void processError(SyntaxNodeException error) {
        OpenLMessagesUtils.addError(error);
    }

    public static IBoundNode checkConditionBoundNode(IBoundNode conditionNode, IBindingContext bindingContext) {
        if (conditionNode != null && !BindHelper.isBooleanType(conditionNode.getType())) {
            if (conditionNode.getType() != NullOpenClass.the) {
                BindHelper.processError(CONDITION_TYPE_MESSAGE, conditionNode.getSyntaxNode(), bindingContext, false);
            }
            return new ErrorBoundNode(conditionNode.getSyntaxNode());
        }
        if (conditionNode != null) {
            BindHelper.checkForSameLeftAndRightExpression(conditionNode, bindingContext);
        }
        return conditionNode;
    }

    public static void checkOnDeprecation(ISyntaxNode node, IBindingContext context, IMethodCaller caller) {
        if (caller instanceof JavaOpenMethod) {
            Method javaMethod = ((JavaOpenMethod)caller).getJavaMethod();
            if (BindHelper.isDeprecated(javaMethod)) {
                String msg = "DEPRECATED '" + javaMethod.getName() + "' function will be removed in the next version!";
                BindHelper.processWarn(msg, node, context);
            }
        } else if (caller instanceof JavaOpenConstructor) {
            Constructor<?> constr = ((JavaOpenConstructor)caller).getJavaConstructor();
            if (BindHelper.isDeprecated(constr)) {
                String msg = "DEPRECATED '" + constr.getName() + "' constructor will be removed in the next version!";
                BindHelper.processWarn(msg, node, context);
            }
        } else if (caller instanceof CastingMethodCaller) {
            BindHelper.checkOnDeprecation(node, context, caller.getMethod());
        }
    }

    public static void checkOnDeprecation(ISyntaxNode node, IBindingContext context, IOpenClass aClass) {
        if (aClass instanceof JavaOpenClass) {
            Class<?> javaClass = ((JavaOpenClass)aClass).getInstanceClass();
            if (javaClass.isAnnotationPresent(Deprecated.class)) {
                String msg = "DEPRECATED '" + javaClass.getName() + "' class will be removed in the next version!";
                BindHelper.processWarn(msg, node, context);
            }
        } else if (aClass != null && aClass.isArray()) {
            BindHelper.checkOnDeprecation(node, context, aClass.getComponentClass());
        }
    }

    public static void checkOnDeprecation(ISyntaxNode node, IBindingContext context, IOpenField filed) {
        Field javaField;
        if (filed instanceof JavaOpenField && BindHelper.isDeprecated(javaField = ((JavaOpenField)filed).getJavaField())) {
            String msg = "DEPRECATED '" + javaField.getName() + "' field will be removed in the next version!";
            BindHelper.processWarn(msg, node, context);
        }
    }

    private static <T extends Member & AnnotatedElement> boolean isDeprecated(T javaField) {
        return ((AnnotatedElement)javaField).isAnnotationPresent(Deprecated.class) || javaField.getDeclaringClass().isAnnotationPresent(Deprecated.class);
    }

    private static void checkForSameLeftAndRightExpression(IBoundNode conditionNode, IBindingContext bindingContext) {
        IBoundNode right;
        IBoundNode left;
        IBoundNode[] children = conditionNode.getChildren();
        if (children != null && children.length == 2 && BindHelper.isSame(left = children[0], right = children[1])) {
            String type = conditionNode.getSyntaxNode().getType();
            if (EQUAL_OPERATORS.contains(type)) {
                BindHelper.processWarn("Condition is always true", conditionNode.getSyntaxNode(), bindingContext);
            } else if (NOT_EQUAL_OPERATORS.contains(type)) {
                BindHelper.processWarn("Condition is always false", conditionNode.getSyntaxNode(), bindingContext);
            }
        }
    }

    private static boolean isSame(IBoundNode left, IBoundNode right) {
        Object rightValue;
        Object leftValue;
        if (left instanceof FieldBoundNode && right instanceof FieldBoundNode) {
            if (((FieldBoundNode)left).getBoundField() == ((FieldBoundNode)right).getBoundField()) {
                if (left.getTargetNode() == right.getTargetNode()) {
                    return true;
                }
                if (BindHelper.isSame(left.getTargetNode(), right.getTargetNode())) {
                    return true;
                }
            }
        } else if (left instanceof LiteralBoundNode && right instanceof LiteralBoundNode && ((leftValue = ((LiteralBoundNode)left).getValue()) == (rightValue = ((LiteralBoundNode)right).getValue()) || leftValue != null && leftValue.equals(rightValue))) {
            return true;
        }
        return false;
    }

    public static void processWarn(String message, ISyntaxNode source, IBindingContext bindingContext) {
        if (bindingContext.isExecutionMode()) {
            OpenLMessagesUtils.addWarn(message);
        } else {
            OpenLMessagesUtils.addWarn(message, source);
        }
    }

    public static IBoundCode makeInvalidCode(IParsedCode parsedCode, ISyntaxNode syntaxNode, IBindingContext bindingContext) {
        ErrorBoundNode boundNode = new ErrorBoundNode(syntaxNode);
        return new BoundCode(parsedCode, boundNode, bindingContext.getErrors(), bindingContext.getLocalVarFrameSize());
    }

    public static IBoundCode makeInvalidCode(IParsedCode parsedCode, ISyntaxNode syntaxNode, SyntaxNodeException[] errors) {
        ErrorBoundNode boundNode = new ErrorBoundNode(syntaxNode);
        return new BoundCode(parsedCode, boundNode, errors, 0);
    }

    public static IBindingContext delegateContext(IBindingContext context, IBindingContextDelegator delegator) {
        if (delegator != null) {
            delegator.setTopDelegate(context);
            return delegator;
        }
        return context;
    }

    public static String getTemporaryVarName(IBindingContext bindingContext, String namespace, String varNamePrefix) {
        int index = 0;
        while (bindingContext.findVar(namespace, varNamePrefix + "$" + index, true) != null) {
            ++index;
        }
        return varNamePrefix + "$" + index;
    }

    private static boolean isBooleanType(IOpenClass type) {
        return type == null || JavaOpenClass.BOOLEAN == type || JavaOpenClass.getOpenClass(Boolean.class) == type;
    }
}

