/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.binding.INodeBinder;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.exception.FieldNotFoundException;
import org.openl.binding.impl.Binder;
import org.openl.binding.impl.LocalFrameBuilder;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.MethodKey;

public class BindingContext
implements IBindingContext {
    private IOpenBinder binder;
    private IOpenClass returnType;
    private OpenL openl;
    private LocalFrameBuilder localFrame = new LocalFrameBuilder();
    private List<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Stack<List<SyntaxNodeException>> errorStack = new Stack();
    private Map<String, Object> externalParams;
    static final Object NOT_FOUND = "NOT_FOUND";
    static final SyntaxNodeException[] NO_ERRORS = new SyntaxNodeException[0];
    Properties contextProperties = new Properties();

    public BindingContext(Binder binder, IOpenClass returnType, OpenL openl) {
        this.binder = binder;
        this.returnType = returnType;
        this.openl = openl;
    }

    @Override
    public synchronized void addAlias(String name, String value) {
        this.aliases.put(name, value);
    }

    @Override
    public void addError(SyntaxNodeException error) {
        this.errors.add(error);
    }

    @Override
    public ILocalVar addParameter(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addType(String namespace, IOpenClass type) {
        throw new UnsupportedOperationException();
    }

    public void removeType(String namespace, IOpenClass type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        return this.localFrame.addVar(namespace, name, type);
    }

    @Override
    public INodeBinder findBinder(ISyntaxNode node) {
        return this.binder.getNodeBinderFactory().getNodeBinder(node);
    }

    @Override
    public IOpenField findFieldFor(IOpenClass type, String fieldName, boolean strictMatch) {
        return type.getField(fieldName, strictMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMethodCaller findMethodCaller(String namespace, String name, IOpenClass[] parTypes) {
        Map<MethodKey, Object> methodCache;
        MethodKey key = new MethodKey(namespace + ':' + name, parTypes, false, true);
        Map<MethodKey, Object> map = methodCache = ((Binder)this.binder).methodCache;
        synchronized (map) {
            Object res = methodCache.get(key);
            if (res == null) {
                IMethodCaller found = this.binder.getMethodFactory().getMethodCaller(namespace, name, parTypes, this.binder.getCastFactory());
                methodCache.put(key, found == null ? NOT_FOUND : found);
                return found;
            }
            if (res == NOT_FOUND) {
                return null;
            }
            return (IMethodCaller)res;
        }
    }

    @Override
    public IOpenClass findType(String namespace, String typeName) {
        return this.binder.getTypeFactory().getType(namespace, typeName);
    }

    @Override
    public IOpenField findVar(String namespace, String name, boolean strictMatch) {
        ILocalVar var = this.localFrame.findLocalVar(namespace, name);
        if (var != null) {
            return var;
        }
        return this.binder.getVarFactory().getVar(namespace, name, strictMatch);
    }

    @Override
    public synchronized String getAlias(String name) {
        return this.aliases.get(name);
    }

    public IOpenBinder getBinder() {
        return this.binder;
    }

    @Override
    public IOpenCast getCast(IOpenClass from, IOpenClass to) {
        return this.binder.getCastFactory().getCast(from, to);
    }

    @Override
    public IOpenClass findClosestClass(IOpenClass openClass1, IOpenClass openClass2) {
        return this.binder.getCastFactory().findClosestClass(openClass1, openClass2);
    }

    @Override
    public SyntaxNodeException[] getErrors() {
        return this.errors.size() == 0 ? NO_ERRORS : this.errors.toArray(new SyntaxNodeException[0]);
    }

    public SyntaxNodeException getError(int i) {
        return this.errors.get(i);
    }

    @Override
    public int getLocalVarFrameSize() {
        return this.localFrame.getLocalVarFrameSize();
    }

    @Override
    public int getNumberOfErrors() {
        return this.errors == null ? 0 : this.errors.size();
    }

    @Override
    public OpenL getOpenL() {
        return this.openl;
    }

    @Override
    public int getParamFrameSize() {
        return 0;
    }

    @Override
    public IOpenClass getReturnType() {
        return this.returnType;
    }

    @Override
    public List<SyntaxNodeException> popErrors() {
        List<SyntaxNodeException> tmp = this.errors;
        this.errors = this.errorStack.pop();
        return tmp;
    }

    @Override
    public void popLocalVarContext() {
        this.localFrame.popLocalVarcontext();
    }

    @Override
    public void pushErrors() {
        this.errorStack.push(this.errors);
        this.errors = new ArrayList<SyntaxNodeException>();
    }

    @Override
    public void pushLocalVarContext() {
        this.localFrame.pushLocalVarContext();
    }

    @Override
    public void setReturnType(IOpenClass type) {
        if (this.returnType != NullOpenClass.the) {
            throw new RuntimeException("Can not override return type " + this.returnType.getName());
        }
        this.returnType = type;
    }

    @Override
    public boolean isExecutionMode() {
        return false;
    }

    @Override
    public Map<String, Object> getExternalParams() {
        return this.externalParams;
    }

    @Override
    public void setExternalParams(Map<String, Object> externalParams) {
        this.externalParams = externalParams;
    }

    @Override
    public IOpenField findRange(String namespace, String rangeStartName, String rangeEndName) throws AmbiguousVarException, FieldNotFoundException {
        throw new FieldNotFoundException("Range:", rangeStartName + ":" + rangeEndName, null);
    }

    @Override
    public String getContextProperty(String name) {
        return this.contextProperties == null ? null : this.contextProperties.getProperty(name);
    }

    @Override
    public void setContextProperty(String name, String value) {
        this.contextProperties.setProperty(name, value);
    }
}

