/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class FieldBoundNode
extends ATargetBoundNode {
    private final IOpenField boundField;
    private final int dims;
    private IOpenClass returnType;

    FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field) {
        super(syntaxNode, (IBoundNode)null, new IBoundNode[0]);
        this.dims = 0;
        this.boundField = field;
    }

    FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field, IBoundNode target, int dims) {
        super(syntaxNode, target, new IBoundNode[0]);
        this.dims = dims;
        this.boundField = field;
    }

    @Override
    public void assign(Object value, IRuntimeEnv env) throws OpenLRuntimeException {
        if (this.dims > 0) {
            throw new UnsupportedOperationException("Multi-reference assignment is not supported.");
        }
        Object target = this.getTarget(env);
        IBoundNode targetNode = this.getTargetNode();
        if (target == null && targetNode != null) {
            target = targetNode.getType().newInstance(env);
            targetNode.assign(target, env);
        }
        this.boundField.set(target, value, env);
    }

    public String getFieldName() {
        return this.boundField.getName();
    }

    IOpenField getBoundField() {
        return this.boundField;
    }

    @Override
    protected Object evaluateRuntime(IRuntimeEnv env) {
        Object target = this.getTarget(env);
        return this.evaluateDim(target, env, this.dims, null);
    }

    private Object evaluateDim(Object target, IRuntimeEnv env, int dims, Class<?> targetType) {
        if (dims == 0) {
            return this.boundField.get(target, env);
        }
        if (target == null) {
            return null;
        }
        int paramsLenght = Array.getLength(target);
        if (targetType == null) {
            targetType = this.getType().getInstanceClass();
        }
        Class<?> componentType = targetType.getComponentType();
        int nextDim = --dims;
        Object results = Array.newInstance(componentType, paramsLenght);
        for (int i = 0; i < paramsLenght; ++i) {
            Object element = Array.get(target, i);
            Object value = this.evaluateDim(element, env, nextDim, componentType);
            if (value == null) continue;
            Array.set(results, i, value);
        }
        return results;
    }

    @Override
    public IOpenClass getType() {
        if (this.returnType == null) {
            this.returnType = this.boundField.getType();
            if (this.dims > 0) {
                this.returnType = this.returnType.getAggregateInfo().getIndexedAggregateType(this.returnType, this.dims);
            }
        }
        return this.returnType;
    }

    @Override
    public boolean isLvalue() {
        return this.boundField.isWritable();
    }

    @Override
    public void updateAssignFieldDependency(BindingDependencies dependencies) {
        dependencies.addAssignField(this.boundField, this);
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addFieldDependency(this.boundField, this);
    }
}

