/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class IdentifierBinder
extends ANodeBinder {
    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        boolean strictMatch = this.isStrictMatch(node);
        String fieldName = ((IdentifierNode)node).getIdentifier();
        IOpenField field = bindingContext.findVar("org.openl.this", fieldName, strictMatch);
        if (field != null) {
            return new FieldBoundNode(node, field);
        }
        IOpenClass type = bindingContext.findType("org.openl.this", fieldName);
        BindHelper.checkOnDeprecation(node, bindingContext, type);
        if (type != null) {
            return new TypeBoundNode(node, type);
        }
        String message = String.format("Field not found: '%s'", fieldName);
        BindHelper.processError(message, node, bindingContext, false);
        return new ErrorBoundNode(node);
    }

    @Override
    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) {
        String fieldName = ((IdentifierNode)node).getIdentifier();
        try {
            IOpenField field;
            IOpenClass type = target.getType();
            int dims = 0;
            while (type.isArray()) {
                ++dims;
                type = type.getComponentClass();
            }
            if (dims > 0 && "length".equals(fieldName)) {
                dims = 0;
                type = target.getType();
                BindHelper.processWarn("DEPRECATED 'length' field for arrays will be removed in the next version. Use length() function instead!", node, bindingContext);
            }
            if ((field = bindingContext.findFieldFor(type, fieldName, false)) == null) {
                String message = String.format("Field not found: '%s' inside '%s' type", fieldName, type);
                BindHelper.processError(message, node, bindingContext, false);
                return new ErrorBoundNode(node);
            }
            if (target.isStaticTarget() != field.isStatic()) {
                if (field.isStatic()) {
                    BindHelper.processWarn("Access of a static field from non-static object", node, bindingContext);
                } else {
                    BindHelper.processError("Access non-static field from a static object", node, bindingContext, false);
                    return new ErrorBoundNode(node);
                }
            }
            BindHelper.checkOnDeprecation(node, bindingContext, field);
            return new FieldBoundNode(node, field, target, dims);
        }
        catch (Throwable t) {
            try {
                BindHelper.processError(node, t, bindingContext);
                return new ErrorBoundNode(node);
            }
            catch (Throwable t2) {
                BindHelper.processError(node, t2, bindingContext);
                return new ErrorBoundNode(node);
            }
        }
    }

    private boolean isStrictMatch(ISyntaxNode node) {
        return !node.getType().contains(".nostrict");
    }
}

