/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;

public class IdentifierSequenceBinder
extends ANodeBinder {
    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        String longName = this.concatChildren(node);
        IdentifierNode newNode = new IdentifierNode("identifier.nostrict", node.getSourceLocation(), longName, node.getModule());
        return IdentifierSequenceBinder.bindChildNode(newNode, bindingContext);
    }

    @Override
    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) {
        try {
            String longName = this.concatChildren(node);
            IdentifierNode newNode = new IdentifierNode("identifier.nostrict", node.getSourceLocation(), longName, node.getModule());
            return IdentifierSequenceBinder.bindTargetNode(newNode, bindingContext, target);
        }
        catch (Throwable t) {
            BindHelper.processError("Cannot bind node", node, t, bindingContext);
            return new ErrorBoundNode(node);
        }
    }

    private String concatChildren(ISyntaxNode node) {
        StringBuilder builder = new StringBuilder(100);
        for (int i = 0; i < node.getNumberOfChildren(); ++i) {
            builder.append(((IdentifierNode)node.getChild(i)).getIdentifier());
        }
        return builder.toString();
    }
}

