/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.math.BigInteger;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.CastNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.LiteralNode;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class IntNodeBinder
extends ANodeBinder {
    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) {
        int len;
        String s = ((LiteralNode)node).getImage();
        if (s.charAt(0) == '$') {
            s = s.substring(1);
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        if (Character.toUpperCase(s.charAt((len = s.length()) - 1)) == 'L') {
            return new LiteralBoundNode(node, Long.decode(s.substring(0, len - 1)), JavaOpenClass.LONG);
        }
        try {
            return new LiteralBoundNode(node, Integer.decode(s), JavaOpenClass.INT);
        }
        catch (NumberFormatException e) {
            try {
                return new LiteralBoundNode(node, Long.decode(s), JavaOpenClass.LONG);
            }
            catch (NumberFormatException e1) {
                return new LiteralBoundNode(node, new BigInteger(s), JavaOpenClass.getOpenClass(BigInteger.class));
            }
        }
    }

    @Override
    public IBoundNode bindType(ISyntaxNode node, IBindingContext bindingContext, IOpenClass type) throws Exception {
        IBoundNode boundNode = IntNodeBinder.bindChildNode(node, bindingContext);
        IOpenCast cast = IntNodeBinder.getCast(boundNode, type, bindingContext, false);
        if (cast == null) {
            return boundNode;
        }
        return new CastNode(null, boundNode, cast, type);
    }
}

