/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Stack;
import org.openl.binding.ILocalVar;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.vm.IRuntimeEnv;

public class LocalFrameBuilder {
    Stack<LocalVarFrameElement> localFrames = new Stack();
    int localVarFrameSize = 0;

    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        ILocalVar var = this.findLocalVar(namespace, name);
        if (var != null) {
            throw new DuplicatedVarException(null, name);
        }
        var = new LocalVar(namespace, name, this.currentFrameSize(), type);
        this.localFrames.peek().add(var);
        return var;
    }

    public int currentFrameSize() {
        int sum = 0;
        for (LocalVarFrameElement element : this.localFrames) {
            sum += element.size();
        }
        return sum;
    }

    public ILocalVar findLocalVar(String namespace, String varname) {
        for (LocalVarFrameElement frame : this.localFrames) {
            for (ILocalVar var : frame) {
                String s1 = var.getNamespace();
                if (!var.getName().equals(varname) || !(s1 != null ? s1.equals(namespace) : namespace == null)) continue;
                return var;
            }
        }
        return null;
    }

    public int getLocalVarFrameSize() {
        return this.localVarFrameSize;
    }

    public LocalVarFrameElement getTopFrame() {
        return this.localFrames.peek();
    }

    public void popLocalVarcontext() {
        this.localVarFrameSize = Math.max(this.localVarFrameSize, this.currentFrameSize());
        this.localFrames.pop();
    }

    public void pushLocalVarContext() {
        this.localFrames.push(new LocalVarFrameElement());
    }

    public static class LocalVarFrameElement
    extends ArrayList<ILocalVar> {
    }

    static class LocalVar
    implements ILocalVar {
        String namespace;
        String name;
        int indexInLocalFrame;
        IOpenClass type;

        LocalVar(String namespace, String name, int indexInLocalFrame, IOpenClass type) {
            this.namespace = namespace;
            this.name = name;
            this.indexInLocalFrame = indexInLocalFrame;
            this.type = type;
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            Object res = env.getLocalFrame()[this.indexInLocalFrame];
            return res != null ? res : this.getType().nullObject();
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return NullOpenClass.the;
        }

        public String getDisplayName(int mode) {
            return this.name;
        }

        @Override
        public int getIndexInLocalFrame() {
            return this.indexInLocalFrame;
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public IOpenClass getType() {
            return this.type;
        }

        @Override
        public boolean isConst() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void set(Object target, Object value, IRuntimeEnv env) {
            env.getLocalFrame()[this.indexInLocalFrame] = value;
        }

        public String toString() {
            return "~" + this.name;
        }
    }
}

