/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.binding.impl.ControlSignalReturn;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOwnTargetMethod;
import org.openl.vm.IRuntimeEnv;

public class MethodBoundNode
extends ATargetBoundNode {
    protected IMethodCaller boundMethod;

    public MethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] child, IMethodCaller methodCaller) {
        this(syntaxNode, child, methodCaller, null);
    }

    public MethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] child, IMethodCaller methodCaller, IBoundNode targetNode) {
        super(syntaxNode, targetNode, child);
        this.boundMethod = methodCaller;
    }

    @Override
    protected Object evaluateRuntime(IRuntimeEnv env) {
        try {
            Object target = this.getTarget(env);
            Object[] pars = this.evaluateChildren(env);
            if (target == null && !(this.boundMethod instanceof IOwnTargetMethod) && !this.boundMethod.getMethod().isStatic()) {
                return this.getType().nullObject();
            }
            return this.boundMethod.invoke(target, pars, env);
        }
        catch (ControlSignalReturn signal) {
            return signal.getReturnValue();
        }
        catch (OpenLRuntimeException opex) {
            opex.pushMethodNode(this);
            throw opex;
        }
    }

    @Override
    public IOpenClass getType() {
        return this.boundMethod.getMethod().getType();
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addMethodDependency(this.boundMethod.getMethod(), this);
    }

    public IMethodCaller getMethodCaller() {
        return this.boundMethod;
    }
}

