/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import java.util.List;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class MultiCallMethodBoundNode
extends MethodBoundNode {
    private IOpenClass returnType;
    private final int[] arrayArgArguments;

    public MultiCallMethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] children, IMethodCaller singleParameterMethod, List<Integer> arrayArgArgumentList) {
        super(syntaxNode, children, singleParameterMethod);
        this.arrayArgArguments = new int[arrayArgArgumentList.size()];
        for (int i = 0; i < arrayArgArgumentList.size(); ++i) {
            this.arrayArgArguments[i] = arrayArgArgumentList.get(i);
        }
    }

    @Override
    protected Object evaluateRuntime(IRuntimeEnv env) {
        Object target = this.getTarget(env);
        Object[] methodParameters = this.evaluateChildren(env);
        int paramsLength = 1;
        int[] nArray = this.arrayArgArguments;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer arrayArgArgument = nArray[i];
            Object arrayParameters = methodParameters[arrayArgArgument];
            if (arrayParameters == null) {
                paramsLength = 0;
                break;
            }
            paramsLength *= Array.getLength(arrayParameters);
        }
        Object results = null;
        Object[] callParameters = (Object[])Array.newInstance(Object.class, methodParameters.length);
        System.arraycopy(methodParameters, 0, callParameters, 0, methodParameters.length);
        IMethodCaller methodCaller = this.getMethodCaller(env);
        if (!JavaOpenClass.VOID.equals(super.getType())) {
            results = Array.newInstance(super.getType().getInstanceClass(), paramsLength);
        }
        if (paramsLength > 0) {
            this.call(methodCaller, target, env, methodParameters, callParameters, 0, results, 0, paramsLength);
        }
        return results;
    }

    private int call(IMethodCaller methodCaller, Object target, IRuntimeEnv env, Object[] allParameters, Object[] callParameters, int iteratedArg, Object results, int callIndex, int resultLength) {
        int iteratedParamNum = this.arrayArgArguments[iteratedArg];
        Object iteratedParameter = allParameters[iteratedParamNum];
        int length = Array.getLength(iteratedParameter);
        for (int i = 0; i < length; ++i) {
            callParameters[iteratedParamNum] = Array.get(iteratedParameter, i);
            if (iteratedArg < this.arrayArgArguments.length - 1) {
                callIndex = this.call(methodCaller, target, env, allParameters, callParameters, iteratedArg + 1, results, callIndex, resultLength);
                continue;
            }
            this.invokeMethodAndSetResultToArray(methodCaller, target, env, callParameters, results, callIndex, resultLength);
            ++callIndex;
        }
        return callIndex;
    }

    protected IMethodCaller getMethodCaller(IRuntimeEnv env) {
        return this.getMethodCaller();
    }

    protected void invokeMethodAndSetResultToArray(IMethodCaller methodCaller, Object target, IRuntimeEnv env, Object[] callParameters, Object results, int index, int resultLength) {
        Object value = methodCaller.invoke(target, callParameters, env);
        if (results != null) {
            Array.set(results, index, value);
        }
    }

    @Override
    public IOpenClass getType() {
        if (this.returnType == null) {
            this.returnType = this.getReturnType();
        }
        return this.returnType;
    }

    private IOpenClass getReturnType() {
        IOpenClass result;
        if (JavaOpenClass.VOID.equals(super.getType())) {
            result = JavaOpenClass.VOID;
        } else {
            IOpenClass singleReturnType = super.getType();
            result = singleReturnType.getAggregateInfo().getIndexedAggregateType(singleReturnType, 1);
        }
        return result;
    }
}

