/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openl.binding.IOpenLibrary;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.util.CollectionUtils;

public class StaticClassLibrary
implements IOpenLibrary {
    Map<String, List<IOpenMethod>> methodNameMap = null;
    private IOpenClass openClass;

    public StaticClassLibrary() {
    }

    public StaticClassLibrary(IOpenClass openClass) {
        this.openClass = openClass;
    }

    @Override
    public IOpenMethod getMethod(String name, IOpenClass[] params) {
        return this.openClass.getMethod(name, params);
    }

    @Override
    public IOpenField getVar(String name, boolean strictMatch) {
        return null;
    }

    public void setOpenClass(IOpenClass c) {
        this.openClass = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IOpenMethod> methods(String name) {
        List<IOpenMethod> found;
        if (this.methodNameMap == null) {
            StaticClassLibrary staticClassLibrary = this;
            synchronized (staticClassLibrary) {
                List methods = CollectionUtils.findAll(this.openClass.getMethods(), (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

                    public boolean evaluate(IOpenMethod method) {
                        return method.isStatic();
                    }
                });
                this.methodNameMap = AOpenClass.buildMethodNameMap(methods);
            }
        }
        return (found = this.methodNameMap.get(name)) == null ? Collections.emptyList() : found;
    }

    @Override
    public IOpenMethod getConstructor(String name, IOpenClass[] params) throws AmbiguousMethodException {
        return null;
    }

    @Override
    public Iterable<IOpenMethod> constructors(String name) {
        return Collections.emptyList();
    }
}

