/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.LiteralNode;
import org.openl.types.java.JavaOpenClass;

public class StringNodeBinder
extends ANodeBinder {
    public static int processOctal(String s, int startIndex, StringBuilder buf) throws Exception {
        char c;
        int i;
        int res = 0;
        for (i = 0; i < 3 && '0' <= (c = s.charAt(startIndex + i)) && c <= '7'; ++i) {
            res = res * 8 + c - 48;
        }
        buf.append((char)res);
        return i;
    }

    public static char processUnicode(String s, int startIndex) throws Exception {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            char c = s.charAt(startIndex + i);
            if ('0' <= c && c <= '9') {
                res = res * 16 + c - 48;
                continue;
            }
            if ('a' <= c && c <= 'f') {
                res = res * 16 + c - 97;
                continue;
            }
            if ('A' <= c && c <= 'F') {
                res = res * 16 + c - 65;
                continue;
            }
            throw new Exception("Invalid unicode sequence character");
        }
        return (char)res;
    }

    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        String s = ((LiteralNode)node).getImage();
        int len = s.length();
        StringBuilder buf = new StringBuilder(len);
        try {
            for (int i = 1; i < len - 1; ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    char nextC = s.charAt(++i);
                    switch (nextC) {
                        case 'b': {
                            buf.append('\b');
                            break;
                        }
                        case 't': {
                            buf.append('\t');
                            break;
                        }
                        case 'n': {
                            buf.append('\n');
                            break;
                        }
                        case 'f': {
                            buf.append('\f');
                            break;
                        }
                        case 'r': {
                            buf.append('\r');
                            break;
                        }
                        case '\"': {
                            buf.append('\"');
                            break;
                        }
                        case '\'': {
                            buf.append('\'');
                            break;
                        }
                        case '\\': {
                            buf.append('\\');
                            break;
                        }
                        case 'u': {
                            buf.append(StringNodeBinder.processUnicode(s, i + 1));
                            i += 4;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            i += StringNodeBinder.processOctal(s, i, buf) - 1;
                        }
                    }
                    continue;
                }
                buf.append(c);
            }
        }
        catch (Exception ex) {
            BindHelper.processError(node, ex, bindingContext);
            return new ErrorBoundNode(node);
        }
        return new LiteralBoundNode(node, buf.toString(), JavaOpenClass.STRING);
    }
}

